/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.explorer.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class ZipUtil {
    private ZipUtil() {
    }

    public static void zipDirectory(File sourceDir, File destFile) throws IOException {
        ZipUtil.zipDirectory(sourceDir, destFile, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void zipDirectory(File sourceDir, File destFile, boolean skipDirectoryEntries) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            FileOutputStream fos = new FileOutputStream(destFile);
            try {
                try (ZipOutputStream zipOut = new ZipOutputStream(fos);){
                    ZipUtil.zipFile(sourceDir, sourceDir.getName(), zipOut, skipDirectoryEntries);
                }
                if (fos == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fos == null) throw throwable;
                fos.close();
                throw throwable;
            }
            fos.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut, boolean skipDirectoryEntries) throws IOException {
        int length;
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            File[] children;
            if (!skipDirectoryEntries) {
                if (fileName.endsWith("/")) {
                    zipOut.putNextEntry(new ZipEntry(fileName));
                    zipOut.closeEntry();
                } else {
                    zipOut.putNextEntry(new ZipEntry(fileName + "/"));
                    zipOut.closeEntry();
                }
            }
            File[] fileArray = children = fileToZip.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile = fileArray[n2];
                ZipUtil.zipFile(childFile, fileName + "/" + childFile.getName(), zipOut, skipDirectoryEntries);
                ++n2;
            }
            return;
        }
        FileInputStream fis = new FileInputStream(fileToZip);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        fis.close();
    }
}

