/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.nodes.operation.getcategory;

import com.nodepit.knime.nodes.HttpRequestNodeParameters;
import com.nodepit.knime.nodes.NodeParametersUtils;
import com.nodepit.knime.nodes.ResponseMapper;
import com.nodepit.knime.nodes.SimpleResponseMapper;
import com.nodepit.knime.nodes.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.image.png.PNGImageCellFactory;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetCategoryNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Set KNIME Version", description="Enable to set the optional field <b>KNIME Version</b>")
    @ValueReference(value=KnimeVersionEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean knimeVersionEnabled = false;
    @Widget(title="KNIME Version", description="KNIME version following <tt>major.minor</tt> format.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=KnimeVersionEnabledRef.class, type=Effect.EffectType.SHOW)
    String knimeVersion = "5.5";
    @Widget(title="NodePit ID", description="The path of the category\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String nodePitId = "/nodepit/nodepit-api";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>NodePit ID:</b> The path of the category</li>\n\t<li><b>Name:</b> Human-readable name of the category.</li>\n\t<li><b>Description:</b> A description of the category.</li>\n\t<li><b>URL:</b> NodePit URL of category page.</li>\n\t<li><b>Path:</b> Path to this category within the hierarchy.</li>\n\t<li><b>Feature Name:</b> Human-readable name of the \u201cfeature\u201d (Eclipse terminology) which contains the category.</li>\n\t<li><b>Feature NodePit ID:</b> Identifier of the \u201cfeature\u201d (Eclipse terminology) which contains the category.</li>\n\t<li><b>Update Site URL:</b> The URL of the update site which contains the category.</li>\n\t<li><b>Update Site Name:</b> Human-readable name of the update site which contains this category.</li>\n\t<li><b>Icon Base64:</b> A 16 \u00d7 16 pixel Base64-encoded PNG image of the category.</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetCategoryNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"nodePitId\":\"rows[0][0]\",\"name\":\"rows[0][1]\",\"description\":\"rows[0][2]\",\"url\":\"rows[0][3]\",\"path\":\"rows[0][4]\",\"featureName\":\"rows[0][5]\",\"featureNodePitId\":\"rows[0][6]\",\"updateSiteUrl\":\"rows[0][7]\",\"updateSiteName\":\"rows[0][8]\",\"iconBase64\":\"rows[0][9]\"}}]").addBodyColumn(new DataColumnSpecCreator("NodePit ID", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Description", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("URL", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Path", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Feature Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Feature NodePit ID", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Update Site URL", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Update Site Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Icon Base64", PNGImageCellFactory.TYPE).createSpec(), true).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetCategoryNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.nodePitId == null || this.nodePitId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cNodePit ID\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("nodePitId", this.nodePitId));
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.knimeVersionEnabled) {
            params.add(new HttpRequestNodeParameters.Param("knimeVersion", this.knimeVersion));
        }
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class GetCategoryNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetCategoryNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class KnimeVersionEnabledRef
    implements BooleanReference {
        private KnimeVersionEnabledRef() {
        }
    }
}

