/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime;

import com.nodepit.knime.Activator;
import com.nodepit.knime.utils.NodePitConnector;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.knime.core.node.NodeLogger;

public class Configuration {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(Configuration.class);
    public static final String NODEPIT_URL_CFG_KEY = "nodePitUrl";
    public static final String NODEPIT_USER_CFG_KEY = "personalNodePitUsername";
    public static final String NODEPIT_PASSWORD_CFG_KEY = "personalNodePitPassword";
    public static final String EXTENDED_CONFIGURATION_CFG_KEY = "nodePitFeatureExtendedConfiguration";
    public static final boolean EXTENDED_CONFIGURATION_DEFAULT = false;
    public static final Feature EXTENDED_CONFIGURATION = new Feature("nodePitFeatureExtendedConfiguration", false);
    public static final String PROFILES_CFG_KEY = "nodePitFeatureProfiles";
    public static final boolean PROFILES_DEFAULT = true;
    public static final Feature PROFILES = new Feature("nodePitFeatureProfiles", true);
    public static final String BROWSER_DISABLE_JS_CFG_KEY = "nodePitDisableJsInBrowser";
    public static final boolean BROWSER_DISABLE_JS_DEFAULT = false;
    public static final Feature BROWSER_DISABLE_JS = new Feature("nodePitDisableJsInBrowser", false);

    public static void updatePluginConfiguration() {
        new Job("Update NodePit Plugin Configuration"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    NodePitConnector.getPluginConfiguration().getFeatures().entrySet().stream().forEach(e -> Activator.getDefault().getPreferenceStore().setValue((String)e.getKey(), ((Boolean)e.getValue()).booleanValue()));
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Unable to load plugin configuration from NodePit. Use last known or default settings instead.");
                    return Status.CANCEL_STATUS;
                }
            }
        }.schedule();
    }

    public static void addPropertyChangeListener(IPropertyChangeListener listener) {
        Objects.requireNonNull(listener, "listener was null");
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(listener);
    }

    public static void removePropertyChangeListener(IPropertyChangeListener listener) {
        Objects.requireNonNull(listener, "listener was null");
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(listener);
    }

    public static boolean shouldDisableSwtBrowserJS() {
        String osVersion = System.getProperty("os.version");
        if (System.getProperty("os.name").toLowerCase().contains("mac") && System.getProperty("os.arch").equals("x86_64") && (osVersion.startsWith("13.0") || osVersion.startsWith("13.1"))) {
            LOGGER.debug((Object)"Disable JavaScript for SWT browser due to the following issue: https://github.com/eclipse-platform/eclipse.platform.swt/issues/452 \u2013 please update to macOS 13.2 to use the full functionality.");
            return true;
        }
        return BROWSER_DISABLE_JS.isActive();
    }

    public static class Feature {
        private final String featureIdentifier;
        private final boolean defaultValue;

        private Feature(String property) {
            this(property, false);
        }

        private Feature(String featureName, boolean defaultValue) {
            this.featureIdentifier = featureName;
            this.defaultValue = defaultValue;
        }

        public boolean isActive() {
            String value = System.getProperty(this.featureIdentifier);
            if (value != null && value.length() > 0) {
                return Boolean.getBoolean(this.featureIdentifier);
            }
            if (Activator.getDefault() != null && Activator.getDefault().getPreferenceStore().contains(this.featureIdentifier)) {
                return Activator.getDefault().getPreferenceStore().getBoolean(this.featureIdentifier);
            }
            return this.defaultValue;
        }
    }
}

