/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.imports;

import com.nodepit.knime.model.ExtensionInfo;
import com.nodepit.knime.model.NodeInfo;
import com.nodepit.knime.model.WorkflowInfo;
import com.nodepit.knime.utils.NodePitConnector;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import java.util.regex.Pattern;
import org.knime.core.node.workflow.contextv2.LocationInfo;
import org.knime.workbench.core.imports.EntityImport;
import org.knime.workbench.core.imports.ExtensionImport;
import org.knime.workbench.core.imports.ImportForbiddenException;
import org.knime.workbench.core.imports.NodeImport;
import org.knime.workbench.core.imports.RepoObjectImport;
import org.knime.workbench.core.imports.URIImporter;
import org.knime.workbench.core.imports.UpdateSiteInfo;

public class NodePitURIImporter
implements URIImporter {
    public boolean canHandle(URI uri) {
        return uri.toString().startsWith(NodePitConnector.getUrl());
    }

    public Optional<Class<? extends EntityImport>> getEntityImportClass(URI uri) {
        if (uri.toString().startsWith(NodePitConnector.getUrl() + "/node/")) {
            return Optional.of(NodeImport.class);
        }
        if (uri.toString().startsWith(NodePitConnector.getUrl() + "/iu/")) {
            return Optional.of(ExtensionImport.class);
        }
        if (uri.toString().startsWith(NodePitConnector.getUrl() + "/workflow/")) {
            return Optional.of(RepoObjectImport.class);
        }
        return Optional.empty();
    }

    public Optional<NodeImport> createNodeImport(URI uri) throws ImportForbiddenException {
        NodeInfo nodeInfo;
        final String nodePitId = uri.toString().replaceAll("^.*\\/node\\/", "");
        try {
            nodeInfo = NodePitConnector.getNodeInfo(nodePitId);
        }
        catch (IOException e) {
            throw new ImportForbiddenException("Could not get node info", (Throwable)e);
        }
        return Optional.of(new NodeImport(){

            public String getFeatureName() {
                return nodeInfo.getFeatureName();
            }

            public String getFeatureSymbolicName() {
                return nodeInfo.getFeatureNodePitId();
            }

            public UpdateSiteInfo getUpdateSiteInfo() {
                return new UpdateSiteInfoImpl(nodeInfo.getUpdateSiteUrl(), nodeInfo.getUpdateSiteName());
            }

            public String getFactoryId() {
                return nodePitId;
            }
        });
    }

    public Optional<ExtensionImport> createExtensionImport(URI uri) throws ImportForbiddenException {
        ExtensionInfo extensionInfo;
        String nodePitId = uri.toString().replaceAll("^.*\\/iu\\/", "");
        try {
            extensionInfo = NodePitConnector.getExtensionInfo(nodePitId);
        }
        catch (IOException e) {
            throw new ImportForbiddenException("Could not get extension info", (Throwable)e);
        }
        return Optional.of(new ExtensionImport(){

            public UpdateSiteInfo getUpdateSiteInfo() {
                return new UpdateSiteInfoImpl(extensionInfo.getUpdateSiteUrl(), extensionInfo.getUpdateSiteName());
            }

            public String getSymbolicName() {
                return extensionInfo.getNodePitId();
            }

            public String getName() {
                return extensionInfo.getName();
            }
        });
    }

    public Optional<RepoObjectImport> createRepoObjectImport(URI uri) throws ImportForbiddenException {
        WorkflowInfo workflowInfo;
        final String nodePitId = uri.toString().replaceAll("^.*\\workflow\\/", "");
        try {
            workflowInfo = NodePitConnector.getWorkflowInfo(nodePitId);
        }
        catch (IOException e) {
            throw new ImportForbiddenException("Could not get workflow info", (Throwable)e);
        }
        return Optional.of(new RepoObjectImport(){

            public RepoObjectImport.RepoObjectType getType() {
                if (workflowInfo.isComponent()) {
                    return RepoObjectImport.RepoObjectType.WorkflowTemplate;
                }
                return RepoObjectImport.RepoObjectType.Workflow;
            }

            public String getName() {
                return workflowInfo.getName();
            }

            public URI getKnimeURI() {
                NodePitURIImporter.ensureNodePitMount();
                String user = NodePitConnector.getUserOptional().orElseThrow(() -> new UnsupportedOperationException("NodePit username is missing; check NodePit preferences."));
                return NodePitURIImporter.createNodePitURI(nodePitId, user);
            }

            public URI getDataURI() {
                return URI.create(workflowInfo.getDownloadUrl());
            }

            public Optional<? extends LocationInfo> locationInfo() {
                return Optional.empty();
            }
        });
    }

    private static void ensureNodePitMount() {
    }

    static URI createNodePitURI(String nodePitId, String username) {
        if (nodePitId.startsWith("com.nodepit.space/" + username)) {
            Object uri = nodePitId;
            uri = ((String)uri).replaceAll("^" + Pattern.quote("com.nodepit.space") + "/", "");
            uri = ((String)uri).replaceAll(Pattern.quote(".kntp") + "$", "");
            uri = "knime://NodePit/" + (String)uri;
            return URI.create((String)uri);
        }
        if (nodePitId.startsWith("com.nodepit.space")) {
            throw new UnsupportedOperationException("Importing from other users is currently not supported");
        }
        throw new UnsupportedOperationException("Import for " + nodePitId + " is currently not supported");
    }

    private static final class UpdateSiteInfoImpl
    implements UpdateSiteInfo {
        private final String url;
        private final String name;

        public UpdateSiteInfoImpl(String url, String name) {
            this.url = url;
            this.name = name;
        }

        public boolean isTrusted() {
            return true;
        }

        public String getVersion() {
            return null;
        }

        public String getUrl() {
            return this.url;
        }

        public String getName() {
            return this.name;
        }
    }
}

