/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.preference;

import com.nodepit.knime.Activator;
import com.nodepit.knime.Configuration;
import com.nodepit.knime.preference.SwtUserAgentRetriever;
import com.nodepit.knime.utils.Images;
import com.nodepit.knime.utils.NodePitConnector;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.text.WordUtils;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class PreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String NODEPIT_URL_CFG_KEY_DEFAULT = "https://nodepit.com";
    public static final String ID = "com.nodepit.knime.preferences";
    private static final int LABEL_LINE_LENGTH = 80;

    public PreferencePage() {
        super(null, Images.NODEPIT_IMAGE_DESCRIPTOR_16PX, 1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        Label label = new Label(parent, 16448);
        label.setText(WordUtils.wrap((String)"NodePit is the world\u2019s first search engine that allows you to easily search, find and install KNIME nodes and workflows. Explore the KNIME community\u2019s variety. Start mining!", (int)80));
        GridData gd = new GridData(768);
        gd.widthHint = 400;
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        if (Configuration.PROFILES.isActive()) {
            label = new Label(parent, 16448);
            label.setText(WordUtils.wrap((String)"NodePit for KNIME is a free extension. We recommend you to create a NodePit account to gather the best possible user experience. This allows you to use features such as bookmarking and uploading of workflows.", (int)80));
            gd = new GridData(768);
            gd.widthHint = 400;
            gd.horizontalSpan = 3;
            label.setLayoutData((Object)gd);
        }
        if (Configuration.PROFILES.isActive()) {
            String signUpUrl = NodePitConnector.getUrl() + "/signup?utm_source=KNIME&utm_medium=Preferences";
            Link link = new Link(parent, 16448);
            link.setText("Get your free NodePit account <a href=\"" + signUpUrl + "\">here</a> and enter your credentials below:\n");
            gd = new GridData(768);
            gd.widthHint = 400;
            gd.horizontalSpan = 3;
            link.setLayoutData((Object)gd);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(e.text));
                    }
                    catch (PartInitException partInitException) {
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            });
        }
        StringFieldEditor urlFieldEditor = new StringFieldEditor("nodePitUrl", "NodePit URL", parent);
        boolean nodePitConfigEnabled = Configuration.EXTENDED_CONFIGURATION.isActive();
        urlFieldEditor.setEnabled(nodePitConfigEnabled, parent);
        this.addField((FieldEditor)urlFieldEditor);
        if (Configuration.PROFILES.isActive()) {
            this.addField((FieldEditor)new StringFieldEditor("personalNodePitUsername", "NodePit username", parent));
            this.addField((FieldEditor)new PasswordFieldEditor("personalNodePitPassword", "NodePit password", parent));
        }
        this.addField((FieldEditor)new SwtUserAgentRetriever(parent));
    }

    private static final class PasswordFieldEditor
    extends StringFieldEditor {
        private PasswordFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            super.doFillIntoGrid(parent, numColumns);
            this.getTextControl().setEchoChar('\u2022');
        }
    }
}

