/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.knime.core.node.KNIMEConstants;

public final class KnimeHelper {
    private KnimeHelper() {
    }

    public static String getKnimeVersion() {
        return KNIMEConstants.MAJOR + "." + KNIMEConstants.MINOR;
    }

    public static boolean isFeaturesInstalled(List<String> featureIds) {
        return featureIds.stream().allMatch(featureId -> !KnimeHelper.collectLocalFeatures(featureId).isEmpty());
    }

    public static void openInstallDialog(String updateSiteUrl, List<String> featureIds, List<String> dependencyUpdateSiteUrls) throws Exception {
        URI updateSiteURI = new URI(updateSiteUrl);
        ArrayList<URI> allUpdateSiteURIs = new ArrayList<URI>();
        allUpdateSiteURIs.add(updateSiteURI);
        for (String dependencyUpdateSiteUrl : dependencyUpdateSiteUrls) {
            allUpdateSiteURIs.add(new URI(dependencyUpdateSiteUrl));
        }
        ProvisioningUI provisioningUI = ProvisioningUI.getDefaultUI();
        Collection<IInstallableUnit> installableUnits = KnimeHelper.collectRemoteFeatures(updateSiteURI, featureIds);
        InstallOperation installOperation = provisioningUI.getInstallOperation(installableUnits, allUpdateSiteURIs.toArray(new URI[allUpdateSiteURIs.size()]));
        LoadMetadataRepositoryJob job = new LoadMetadataRepositoryJob(provisioningUI);
        provisioningUI.openInstallWizard(installableUnits, installOperation, job);
    }

    private static Collection<IInstallableUnit> collectLocalFeatures(String featureId) {
        ProvisioningSession session = ProvisioningUI.getDefaultUI().getSession();
        IProvisioningAgent agent = session.getProvisioningAgent();
        IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
        IProfile profile = profileRegistry.getProfile("_SELF_");
        if (profile == null) {
            return Collections.emptySet();
        }
        return profile.query(QueryUtil.createIUQuery((String)featureId), null).toUnmodifiableSet();
    }

    private static Collection<IInstallableUnit> collectRemoteFeatures(URI updateSiteUrl, List<String> featureIds) throws URISyntaxException, ProvisionException, OperationCanceledException {
        ProvisioningSession session = ProvisioningUI.getDefaultUI().getSession();
        IProvisioningAgent agent = session.getProvisioningAgent();
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        manager.addRepository(updateSiteUrl);
        IMetadataRepository metadataRepo = manager.loadRepository(updateSiteUrl, null);
        return metadataRepo.query(QueryUtil.createLatestQuery((IQuery)QueryUtil.createCompoundQuery((Collection)featureIds.stream().map(QueryUtil::createIUQuery).collect(Collectors.toList()), (boolean)false)), null).toUnmodifiableSet();
    }
}

