/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class NodePitUrlParser {
    public static NodePitUrl parseUrl(String url) throws URISyntaxException {
        Objects.requireNonNull(url, "url was <null>");
        URI uri = new URI(url);
        if (!"nodepit".equals(uri.getScheme())) {
            throw new URISyntaxException(url, "Expected a nodepit: URL.");
        }
        String actionName = uri.getHost();
        HashMap<String, String> parameters = new HashMap<String, String>();
        String query = uri.getQuery();
        if (query != null) {
            String[] paramSplit;
            String[] stringArray = paramSplit = query.split("&");
            int n = paramSplit.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                String[] keyValueSplit = param.split("=");
                parameters.put(keyValueSplit[0], keyValueSplit.length > 1 ? keyValueSplit[1] : null);
                ++n2;
            }
        }
        return new NodePitUrl(actionName, Collections.unmodifiableMap(parameters));
    }

    private NodePitUrlParser() {
    }

    public static final class NodePitUrl {
        public final String actionName;
        public final Map<String, String> parameters;

        NodePitUrl(String actionName, Map<String, String> parameters) {
            this.actionName = actionName;
            this.parameters = parameters;
        }

        public String getParameter(String key) {
            return this.parameters.get(key);
        }
    }
}

