/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.nodes.auth.basic;

import com.nodepit.knime.nodes.InterceptorFactory;
import java.io.IOException;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class BasicInterceptorFactory
extends InterceptorFactory<HttpAuthData> {
    public static final String IDENTIFIER = "basic";

    public BasicInterceptorFactory() {
        super(IDENTIFIER, HttpAuthData.class);
    }

    @Override
    protected Interceptor createInterceptor(final HttpAuthData data) {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request originalRequest = chain.request();
                Request authRequest = originalRequest.newBuilder().header("Authorization", Credentials.basic((String)data.username, (String)data.password)).build();
                return chain.proceed(authRequest);
            }
        };
    }

    public static final class HttpAuthData {
        String username;
        String password;
        String bearer;
    }
}

