/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.nodes.auth.basic;

import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParameters;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.widget.credentials.Credentials;
import org.knime.node.parameters.widget.credentials.PasswordWidget;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class BasicNodeParameters
implements NodeParameters {
    @Widget(title="Username", description="")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String username = "";
    @Widget(title="Password", description="")
    @Migrate(loadDefaultIfAbsent=true)
    @PasswordWidget(passwordLabel="")
    @Persistor(value=PasswordPersistor.class)
    Credentials password = new Credentials();

    BasicNodeParameters() {
    }

    private static final class PasswordPersistor
    implements NodeParametersPersistor<Credentials> {
        static final String CONFIG_KEY = "password";

        private PasswordPersistor() {
        }

        public Credentials load(NodeSettingsRO settings) throws InvalidSettingsException {
            return new Credentials("", settings.getString(CONFIG_KEY));
        }

        public void save(Credentials obj, NodeSettingsWO settings) {
            settings.addString(CONFIG_KEY, obj.getPassword());
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }
}

