/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.nodes.operation.getnodeimage;

import com.nodepit.knime.nodes.HttpRequestNodeParameters;
import com.nodepit.knime.nodes.NodeParametersUtils;
import com.nodepit.knime.nodes.ResponseMapper;
import com.nodepit.knime.nodes.SimpleResponseMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;
import org.knime.node.parameters.widget.number.NumberInputWidgetValidation;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetNodeImageNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Set KNIME Version", description="Enable to set the optional field <b>KNIME Version</b>")
    @ValueReference(value=KnimeVersionEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean knimeVersionEnabled = false;
    @Widget(title="KNIME Version", description="KNIME version following <tt>major.minor</tt> format.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=KnimeVersionEnabledRef.class, type=Effect.EffectType.SHOW)
    String knimeVersion = "5.5";
    @Widget(title="Set Execution State", description="Enable to set the optional field <b>Execution State</b>")
    @ValueReference(value=ExecutionStateEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean executionStateEnabled = false;
    @Widget(title="Execution State", description="The state of the traffic lights shown below the node. If unset, no traffic lights are shown.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ExecutionStateEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Execution_StateChoicesProvider.class)
    String executionState = EXECUTION_STATE_VALUES[0];
    private static final String[] EXECUTION_STATE_VALUES = new String[]{"red", "yellow", "green"};
    @Widget(title="Set Add Node Name", description="Enable to set the optional field <b>Add Node Name</b>")
    @ValueReference(value=AddNodeNameEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean addNodeNameEnabled = false;
    @Widget(title="Add Node Name", description="Enable to show the node name. Make sure to set approriate <tt>canvasWidth</tt> and <tt>canvasHeight</tt> so that the node name can be fully displayed.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=AddNodeNameEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Add_Node_NamePersistor.class)
    String addNodeName = "false";
    @Widget(title="Set Width", description="Enable to set the optional field <b>Width</b>")
    @ValueReference(value=WidthEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean widthEnabled = false;
    @Widget(title="Width", description="Width of the generated image (only when type is <tt>png</tt>)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=WidthEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget(minValidation=WidthMinValidation.class)
    int width = 0;
    @Widget(title="Set Height", description="Enable to set the optional field <b>Height</b>")
    @ValueReference(value=HeightEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean heightEnabled = false;
    @Widget(title="Height", description="Height of the generated image (only when type is <tt>png</tt>)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=HeightEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget(minValidation=HeightMinValidation.class)
    int height = 0;
    @Widget(title="Set Canvas Width", description="Enable to set the optional field <b>Canvas Width</b>")
    @ValueReference(value=CanvasWidthEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean canvasWidthEnabled = false;
    @Widget(title="Canvas Width", description="Width of the canvas in pixels. If unset, the canvas size will be sufficient to show the entire node (but not necessarily the node name).\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=CanvasWidthEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget(minValidation=Canvas_WidthMinValidation.class)
    int canvasWidth = 0;
    @Widget(title="Set Canvas Height", description="Enable to set the optional field <b>Canvas Height</b>")
    @ValueReference(value=CanvasHeightEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean canvasHeightEnabled = false;
    @Widget(title="Canvas Height", description="Height of the canvas in pixels. If unset, the canvas size will be sufficient to show the entire node (but not necessarily the node name).\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=CanvasHeightEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget(minValidation=Canvas_HeightMinValidation.class)
    int canvasHeight = 0;
    @Widget(title="Set Background Color", description="Enable to set the optional field <b>Background Color</b>")
    @ValueReference(value=BackgroundColorEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean backgroundColorEnabled = false;
    @Widget(title="Background Color", description="Background color of the canvas. You can use HTML color names such as <tt>white</tt> or hex codes such as <tt>#fff</tt>. If unset, the background color will be transparent.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=BackgroundColorEnabledRef.class, type=Effect.EffectType.SHOW)
    String backgroundColor = null;
    @Widget(title="NodePit ID", description="Unique node (factory) identifier\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String nodePitId = "ws.palladian.nodes.retrieval.parser.HtmlParserNodeFactory";
    private static final String[] RESPONSE_TYPE_VALUES = new String[]{"image/png", "image/svg+xml"};
    private static final String RESPONSE_TYPE_DEFAULT_VALUE = "image/png";
    @Widget(title="Response Type", description="Specify the response type. The following response types are available:\n<ul>\n\t<li><tt>image/png</tt></li>\n\t<li><tt>image/svg+xml</tt></li>\n</ul>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=ResponseTypeChoicesProvider.class)
    String responseType = "image/png";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetNodeImageNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    GetNodeImageNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.nodePitId == null || this.nodePitId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cNodePit ID\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return this.responseType;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("nodePitId", this.nodePitId));
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.knimeVersionEnabled) {
            params.add(new HttpRequestNodeParameters.Param("knimeVersion", this.knimeVersion));
        }
        if (this.executionStateEnabled) {
            params.add(new HttpRequestNodeParameters.Param("executionState", this.executionState));
        }
        if (this.addNodeNameEnabled) {
            params.add(new HttpRequestNodeParameters.Param("addNodeName", this.addNodeName));
        }
        if (this.widthEnabled) {
            params.add(new HttpRequestNodeParameters.Param("width", this.width));
        }
        if (this.heightEnabled) {
            params.add(new HttpRequestNodeParameters.Param("height", this.height));
        }
        if (this.canvasWidthEnabled) {
            params.add(new HttpRequestNodeParameters.Param("canvasWidth", this.canvasWidth));
        }
        if (this.canvasHeightEnabled) {
            params.add(new HttpRequestNodeParameters.Param("canvasHeight", this.canvasHeight));
        }
        if (this.backgroundColorEnabled) {
            params.add(new HttpRequestNodeParameters.Param("backgroundColor", this.backgroundColor));
        }
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class AddNodeNameEnabledRef
    implements BooleanReference {
        private AddNodeNameEnabledRef() {
        }
    }

    private static final class Add_Node_NamePersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "addNodeName";

        private Add_Node_NamePersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class BackgroundColorEnabledRef
    implements BooleanReference {
        private BackgroundColorEnabledRef() {
        }
    }

    private static final class CanvasHeightEnabledRef
    implements BooleanReference {
        private CanvasHeightEnabledRef() {
        }
    }

    private static final class CanvasWidthEnabledRef
    implements BooleanReference {
        private CanvasWidthEnabledRef() {
        }
    }

    private static final class Canvas_HeightMinValidation
    extends NumberInputWidgetValidation.MinValidation {
        private Canvas_HeightMinValidation() {
        }

        public double getMin() {
            return 0.0;
        }
    }

    private static final class Canvas_WidthMinValidation
    extends NumberInputWidgetValidation.MinValidation {
        private Canvas_WidthMinValidation() {
        }

        public double getMin() {
            return 0.0;
        }
    }

    private static final class ExecutionStateEnabledRef
    implements BooleanReference {
        private ExecutionStateEnabledRef() {
        }
    }

    private static final class Execution_StateChoicesProvider
    implements StringChoicesProvider {
        private Execution_StateChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(EXECUTION_STATE_VALUES);
        }
    }

    private static final class GetNodeImageNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetNodeImageNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class HeightEnabledRef
    implements BooleanReference {
        private HeightEnabledRef() {
        }
    }

    private static final class HeightMinValidation
    extends NumberInputWidgetValidation.MinValidation {
        private HeightMinValidation() {
        }

        public double getMin() {
            return 0.0;
        }
    }

    private static final class KnimeVersionEnabledRef
    implements BooleanReference {
        private KnimeVersionEnabledRef() {
        }
    }

    private static final class ResponseTypeChoicesProvider
    implements StringChoicesProvider {
        private ResponseTypeChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.stream(RESPONSE_TYPE_VALUES).toList();
        }
    }

    private static final class WidthEnabledRef
    implements BooleanReference {
        private WidthEnabledRef() {
        }
    }

    private static final class WidthMinValidation
    extends NumberInputWidgetValidation.MinValidation {
        private WidthMinValidation() {
        }

        public double getMin() {
            return 0.0;
        }
    }
}

