/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.nodes.operation.getnodes;

import com.nodepit.knime.nodes.HttpRequestNodeParameters;
import com.nodepit.knime.nodes.NodeParametersUtils;
import com.nodepit.knime.nodes.ResponseMapper;
import com.nodepit.knime.nodes.SimpleResponseMapper;
import com.nodepit.knime.nodes.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;
import org.knime.node.parameters.widget.number.NumberInputWidgetValidation;

class GetNodesNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Set KNIME Version", description="Enable to set the optional field <b>KNIME Version</b>")
    @ValueReference(value=KnimeVersionEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean knimeVersionEnabled = false;
    @Widget(title="KNIME Version", description="KNIME version following <tt>major.minor</tt> format.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=KnimeVersionEnabledRef.class, type=Effect.EffectType.SHOW)
    String knimeVersion = "5.5";
    @Widget(title="Set Skip", description="Enable to set the optional field <b>Skip</b>")
    @ValueReference(value=SkipEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean skipEnabled = false;
    @Widget(title="Skip", description="The number of results to skip\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=SkipEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget(minValidation=SkipMinValidation.class)
    int skip = 0;
    @Widget(title="Set Limit", description="Enable to set the optional field <b>Limit</b>")
    @ValueReference(value=LimitEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean limitEnabled = false;
    @Widget(title="Limit", description="Number of results to return\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=LimitEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget(minValidation=LimitMinValidation.class, maxValidation=LimitMaxValidation.class)
    int limit = 10;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>NodePit ID:</b> Unique node (factory) identifier</li>\n\t<li><b>Name:</b> Human-readable name of the node</li>\n\t<li><b>URL:</b> NodePit URL of node page</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetNodesNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"items\":{\"*\":{\"nodePitId\":\"rows[#2][0]\",\"name\":\"rows[#2][1]\",\"url\":\"rows[#2][2]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("NodePit ID", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("URL", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetNodesNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.knimeVersionEnabled) {
            params.add(new HttpRequestNodeParameters.Param("knimeVersion", this.knimeVersion));
        }
        if (this.skipEnabled) {
            params.add(new HttpRequestNodeParameters.Param("skip", this.skip));
        }
        if (this.limitEnabled) {
            params.add(new HttpRequestNodeParameters.Param("limit", this.limit));
        }
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class GetNodesNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetNodesNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class KnimeVersionEnabledRef
    implements BooleanReference {
        private KnimeVersionEnabledRef() {
        }
    }

    private static final class LimitEnabledRef
    implements BooleanReference {
        private LimitEnabledRef() {
        }
    }

    private static final class LimitMaxValidation
    extends NumberInputWidgetValidation.MaxValidation {
        private LimitMaxValidation() {
        }

        public double getMax() {
            return 50.0;
        }
    }

    private static final class LimitMinValidation
    extends NumberInputWidgetValidation.MinValidation {
        private LimitMinValidation() {
        }

        public double getMin() {
            return 1.0;
        }
    }

    private static final class SkipEnabledRef
    implements BooleanReference {
        private SkipEnabledRef() {
        }
    }

    private static final class SkipMinValidation
    extends NumberInputWidgetValidation.MinValidation {
        private SkipMinValidation() {
        }

        public double getMin() {
            return 0.0;
        }
    }
}

