/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.nodes.operation.getversions;

import com.nodepit.knime.nodes.HttpRequestNodeParameters;
import com.nodepit.knime.nodes.NodeParametersUtils;
import com.nodepit.knime.nodes.ResponseMapper;
import com.nodepit.knime.nodes.SimpleResponseMapper;
import com.nodepit.knime.nodes.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;

class GetVersionsNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Set Arch", description="Enable to set the optional field <b>Arch</b>")
    @ValueReference(value=ArchEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean archEnabled = false;
    @Widget(title="Arch", description="Filter by CPU architecture\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ArchEnabledRef.class, type=Effect.EffectType.SHOW)
    String arch = "x86_64";
    @Widget(title="Set OS", description="Enable to set the optional field <b>OS</b>")
    @ValueReference(value=OsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean osEnabled = false;
    @Widget(title="OS", description="Filter by operating system\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=OsEnabledRef.class, type=Effect.EffectType.SHOW)
    String os = "win32";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Version:</b> The version</li>\n\t<li><b>URL:</b> Download link</li>\n\t<li><b>Release Date:</b> Release date of this version</li>\n\t<li><b>Arch:</b> CPU architecture</li>\n\t<li><b>OS:</b> Operating system</li>\n\t<li><b>MD5:</b> </li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetVersionsNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"items\":{\"*\":{\"version\":\"rows[#2][0]\",\"url\":\"rows[#2][1]\",\"releaseDate\":\"rows[#2][2]\",\"arch\":\"rows[#2][3]\",\"os\":\"rows[#2][4]\",\"md5\":\"rows[#2][5]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("Version", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("URL", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Release Date", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Arch", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("OS", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("MD5", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetVersionsNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.archEnabled) {
            params.add(new HttpRequestNodeParameters.Param("arch", this.arch));
        }
        if (this.osEnabled) {
            params.add(new HttpRequestNodeParameters.Param("os", this.os));
        }
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class ArchEnabledRef
    implements BooleanReference {
        private ArchEnabledRef() {
        }
    }

    private static final class GetVersionsNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetVersionsNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class OsEnabledRef
    implements BooleanReference {
        private OsEnabledRef() {
        }
    }
}

