/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.nodes.operation.getworkflow;

import com.nodepit.knime.nodes.HttpRequestNodeParameters;
import com.nodepit.knime.nodes.NodeParametersUtils;
import com.nodepit.knime.nodes.ResponseMapper;
import com.nodepit.knime.nodes.SimpleResponseMapper;
import com.nodepit.knime.nodes.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetWorkflowNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="NodePit ID", description="The path to the workflow; it consists of a location identifier (e.g. <tt>com.nodepit.workflows</tt>), the directory hierarchy, and the workflow name, all separated by <tt>/</tt>.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String nodePitId = "com.nodepit.workflows/elasticsearch/01-Query-Elasticsearch.knwf";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>NodePit ID:</b> </li>\n\t<li><b>Name:</b> </li>\n\t<li><b>Component:</b> </li>\n\t<li><b>URL:</b> </li>\n\t<li><b>Nodes:</b> </li>\n\t<li><b>Annotations:</b> </li>\n\t<li><b>Path:</b> </li>\n\t<li><b>Download URL:</b> </li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetWorkflowNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"nodePitId\":\"rows[0][0]\",\"name\":\"rows[0][1]\",\"component\":\"rows[0][2]\",\"url\":\"rows[0][3]\",\"nodes\":\"rows[0][4]\",\"annotations\":\"rows[0][5]\",\"path\":\"rows[0][6]\",\"downloadUrl\":\"rows[0][7]\"}}]").addBodyColumn(new DataColumnSpecCreator("NodePit ID", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Component", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("URL", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Nodes", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Annotations", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Path", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Download URL", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetWorkflowNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.nodePitId == null || this.nodePitId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cNodePit ID\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("nodePitId", this.nodePitId));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class GetWorkflowNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetWorkflowNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

