/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.explorer;

import com.nodepit.knime.Configuration;
import com.nodepit.knime.explorer.Activator;
import com.nodepit.knime.explorer.WebDavFileStore;
import com.nodepit.knime.explorer.WebDavFileStoreConfig;
import com.nodepit.knime.explorer.WebDavFileStoreConfigSource;
import com.nodepit.knime.explorer.actions.OpenPreferencesAction;
import com.nodepit.knime.explorer.jobs.MoveOrCopyJob;
import com.nodepit.knime.explorer.jobs.UploadJob;
import com.nodepit.knime.explorer.utils.Lazy;
import com.nodepit.knime.utils.Images;
import com.nodepit.knime.utils.NodePitConnector;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.knime.core.node.NodeLogger;
import org.knime.core.workbench.mountpoint.api.WorkbenchMountPoint;
import org.knime.workbench.core.util.ImageRepository;
import org.knime.workbench.explorer.filesystem.AbstractExplorerFileInfo;
import org.knime.workbench.explorer.filesystem.AbstractExplorerFileStore;
import org.knime.workbench.explorer.filesystem.LocalExplorerFileStore;
import org.knime.workbench.explorer.filesystem.MessageFileStore;
import org.knime.workbench.explorer.filesystem.RemoteExplorerFileStore;
import org.knime.workbench.explorer.filesystem.TmpLocalExplorerFile;
import org.knime.workbench.explorer.view.AbstractContentProvider;
import org.knime.workbench.explorer.view.AbstractContentProviderFactory;
import org.knime.workbench.explorer.view.ExplorerView;
import org.knime.workbench.explorer.view.actions.GlobalDeleteAction;
import org.knime.workbench.explorer.view.actions.GlobalRefreshAction;
import org.knime.workbench.explorer.view.actions.GlobalRenameAction;
import org.knime.workbench.explorer.view.actions.NewWorkflowGroupAction;
import org.knime.workbench.explorer.view.dnd.DragAndDropUtils;
import org.osgi.framework.Bundle;

class WebDavContentProvider
extends AbstractContentProvider {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(WebDavContentProvider.class);
    private static final Lazy<Image> PUBLIC_DIRECTORY_IMAGE_LAZY = new Lazy<Image>(() -> ImageRepository.getImage((URL)FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("/icons/globe-share.png"), null)));
    private final WebDavFileStoreConfig config;
    private final WebDavFileStore rootStore;
    private final IPropertyChangeListener configPropertyListener;
    private final Object globalLock = new Object();

    WebDavContentProvider(AbstractContentProviderFactory myCreator, WorkbenchMountPoint mountPoint) {
        super(myCreator, mountPoint);
        LOGGER.debugWithFormat("new NodePitContentProvider(%s,%s)", new Object[]{myCreator, mountPoint.getMountID()});
        this.config = WebDavFileStoreConfigSource.getConfig();
        this.rootStore = new WebDavFileStore(this.getMountID(), "/", this.config, null, null, this.globalLock);
        this.configPropertyListener = this::refresh;
        Configuration.addPropertyChangeListener((IPropertyChangeListener)this.configPropertyListener);
    }

    private void refresh(PropertyChangeEvent event) {
        if (this.rootStore.isRefreshable() && Arrays.asList("nodePitUrl", "personalNodePitUsername", "personalNodePitPassword").contains(event.getProperty())) {
            LOGGER.debugWithFormat("Changed property %s -- refreshing the store", new Object[]{event.getProperty()});
            this.rootStore.refresh();
        }
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void dispose() {
        LOGGER.debug((Object)"dispose");
        Configuration.removePropertyChangeListener((IPropertyChangeListener)this.configPropertyListener);
    }

    public String toString() {
        return NodePitConnector.getUserOptional().orElse("Missing credentials!");
    }

    public Image getImage() {
        return Images.NODEPIT_IMAGE_16PX;
    }

    public Image getImage(Object element) {
        WebDavFileStore webDavFileStore;
        if (element instanceof WebDavFileStore && (webDavFileStore = (WebDavFileStore)((Object)element)).fetchInfo().isPublicDirectory()) {
            return PUBLIC_DIRECTORY_IMAGE_LAZY.get();
        }
        Image image = super.getImage(element);
        return image != null ? image : WebDavContentProvider.getWorkspaceImage((AbstractExplorerFileStore)((WebDavFileStore)((Object)element)));
    }

    public String getText(Object element) {
        if (!(element instanceof WebDavFileStore)) {
            return element.toString();
        }
        WebDavFileStore f = (WebDavFileStore)((Object)element);
        return f.getName();
    }

    public AbstractExplorerFileStore getFileStore(String fullPath) {
        return (AbstractExplorerFileStore)this.rootStore.getFileStore((IPath)new Path(fullPath));
    }

    public AbstractExplorerFileStore getFileStore(URI uri) {
        if (!NodePitConnector.getUserOptional().isPresent()) {
            return this.rootStore;
        }
        String path = uri.getPath();
        path = path.replaceAll("^/" + Pattern.quote((String)NodePitConnector.getUserOptional().get()), "");
        path = WebDavFileStore.stripExtension(path);
        return this.getFileStore(path);
    }

    public LocalExplorerFileStore fromLocalFile(File file) {
        return null;
    }

    public void addContextMenuActions(ExplorerView view, IMenuManager manager, Set<String> visibleMountIDs, Map<AbstractContentProvider, List<AbstractExplorerFileStore>> selection) {
        List<AbstractExplorerFileStore> selectedStores;
        manager.removeAll();
        if (selection != null && selection.entrySet().size() == 1 && (selectedStores = selection.get((Object)this)) != null && selectedStores.size() == 1 && selectedStores.get(0) instanceof MessageFileStore) {
            manager.add((IAction)new OpenPreferencesAction(view));
            return;
        }
        manager.add((IAction)new NewWorkflowGroupAction(view));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new GlobalDeleteAction(view));
        manager.add((IAction)new GlobalRenameAction(view));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new GlobalRefreshAction(view));
        manager.add((IContributionItem)new Separator());
    }

    public boolean validateDrop(AbstractExplorerFileStore target, int operation, TransferData transferType) {
        if (!(target instanceof WebDavFileStore)) {
            return false;
        }
        if (!((WebDavFileStore)target).fetchInfo().isWorkflowGroup()) {
            return false;
        }
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
        ISelection selection = transfer.getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            for (Object element : ((IStructuredSelection)selection).toList()) {
                AbstractExplorerFileStore source = DragAndDropUtils.getFileStore(element);
                if (source == null) {
                    LOGGER.debug((Object)"DragAndDropUtils.getFileStore returned null");
                    return false;
                }
                if (source.getMountID().equals(this.getMountID())) continue;
                if (!(source instanceof LocalExplorerFileStore)) {
                    return false;
                }
                AbstractExplorerFileInfo info = source.fetchInfo();
                if (info.isWorkflow() || info.isWorkflowTemplate() || info.isFile() || info.isWorkflowGroup()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean performDrop(ExplorerView view, Object data, AbstractExplorerFileStore target, int operation) {
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
        ISelection selection = transfer.getSelection();
        if (selection instanceof IStructuredSelection) {
            List fileStores = DragAndDropUtils.getExplorerFileStores((IStructuredSelection)((IStructuredSelection)selection));
            return this.copyOrMove(view, fileStores, target, 2 == operation);
        }
        if (data instanceof String[]) {
            List<AbstractExplorerFileStore> fileStores = Arrays.stream((String[])data).map(path -> new TmpLocalExplorerFile(new File((String)path))).collect(Collectors.toList());
            return this.copyOrMove(view, fileStores, target, 2 == operation);
        }
        return false;
    }

    public boolean dragStart(List<AbstractExplorerFileStore> fileStores) {
        return true;
    }

    public boolean canHostMetaNodeTemplates() {
        return true;
    }

    protected File metaTemplateDropGetTempDir(AbstractExplorerFileStore target) {
        try {
            File wrapperDir = Files.createTempDirectory("NodePitTemplate_" + target.getName(), new FileAttribute[0]).toFile();
            File tempDir = new File(wrapperDir, target.getName());
            return tempDir.mkdirs() ? tempDir : wrapperDir;
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Error while uploading template %s", target.getName()), e);
        }
    }

    protected void metaTemplateDropFinish(AbstractExplorerFileStore targetFileStore, File tmpDir) {
        TmpLocalExplorerFile source = new TmpLocalExplorerFile(tmpDir, true);
        WebDavFileStore target = (WebDavFileStore)targetFileStore;
        new UploadJob((LocalExplorerFileStore)source, target, true, t -> Display.getDefault().syncExec(() -> target.getParent().refresh()), this.config.getSardine()).schedule();
    }

    public boolean canHostDataFiles() {
        return false;
    }

    public boolean supportsSnapshots() {
        return false;
    }

    public AbstractExplorerFileStore[] getChildren(Object parentElement) {
        if (parentElement instanceof WebDavFileStore) {
            WebDavFileStore fileStore = (WebDavFileStore)((Object)parentElement);
            try {
                return fileStore.childStores(0, null);
            }
            catch (CoreException coreException) {}
        }
        return NO_CHILD;
    }

    public AbstractExplorerFileStore[] getElements(Object inputElement) {
        return null;
    }

    public AbstractExplorerFileStore getParent(Object element) {
        return null;
    }

    public boolean isRemote() {
        return true;
    }

    public boolean isWritable() {
        return true;
    }

    public boolean copyOrMove(ExplorerView view, List<AbstractExplorerFileStore> fileStores, AbstractExplorerFileStore targetDir, boolean performMove) {
        for (AbstractExplorerFileStore source : fileStores) {
            WebDavFileStore targetStore = (WebDavFileStore)targetDir.getChild(source.getName());
            if (source.getMountID().equals(this.getMountID())) {
                new MoveOrCopyJob((WebDavFileStore)source, targetStore, performMove ? MoveOrCopyJob.Operation.MOVE : MoveOrCopyJob.Operation.COPY, this.config.getSardine()).schedule();
                continue;
            }
            if (source instanceof LocalExplorerFileStore) {
                try {
                    this.performUploadAsync((LocalExplorerFileStore)source, targetStore, performMove, false, t -> Display.getDefault().syncExec(() -> ((AbstractExplorerFileStore)targetDir).refresh()));
                    continue;
                }
                catch (CoreException e) {
                    LOGGER.error((Throwable)e);
                    return false;
                }
            }
            throw new UnsupportedOperationException("copyOrMove is (currently) not supported");
        }
        return true;
    }

    public void performDownloadAsync(RemoteExplorerFileStore source, LocalExplorerFileStore target, boolean deleteSource, AbstractContentProvider.AfterRunCallback afterRunCallback) {
        throw new UnsupportedOperationException("performDownloadAsync is (currently) not supported");
    }

    public void performUploadAsync(LocalExplorerFileStore source, RemoteExplorerFileStore target, boolean deleteSource, boolean excludeDataInWorkflows, AbstractContentProvider.AfterRunCallback callback) throws CoreException {
        new UploadJob(source, (WebDavFileStore)target, excludeDataInWorkflows, callback, this.config.getSardine()).schedule();
    }
}

