/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.explorer;

import com.github.sardine.DavResource;
import com.github.sardine.impl.SardineException;
import com.nodepit.knime.explorer.WebDavFileInfo;
import com.nodepit.knime.explorer.WebDavFileStoreConfig;
import com.nodepit.knime.explorer.jobs.BuildDownloadStreamJob;
import com.nodepit.knime.explorer.jobs.DeleteJob;
import com.nodepit.knime.explorer.jobs.DownloadAndUnzipJob;
import com.nodepit.knime.explorer.jobs.MkDirJob;
import com.nodepit.knime.explorer.jobs.MoveOrCopyJob;
import com.nodepit.knime.explorer.utils.Logger;
import com.nodepit.knime.explorer.utils.NoOpAuthenticator;
import com.nodepit.knime.utils.NodePitConstants;
import com.nodepit.knime.utils.UrlUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.knime.core.node.workflow.contextv2.HubSpaceLocationInfo;
import org.knime.core.node.workflow.contextv2.HubSpaceLocationInfoBuilderFactory;
import org.knime.core.node.workflow.contextv2.RestLocationInfo;
import org.knime.core.util.auth.Authenticator;
import org.knime.workbench.explorer.filesystem.AbstractExplorerFileInfo;
import org.knime.workbench.explorer.filesystem.AbstractExplorerFileStore;
import org.knime.workbench.explorer.filesystem.RemoteDownloadStream;
import org.knime.workbench.explorer.filesystem.RemoteExplorerFileStore;
import org.knime.workbench.explorer.filesystem.RemoteUploadStream;
import org.knime.workbench.explorer.view.AbstractContentProvider;

public class WebDavFileStore
extends RemoteExplorerFileStore {
    private static final Logger LOGGER = Logger.create(WebDavFileStore.class);
    private final RemoteExplorerFileStore parent;
    private final WebDavFileStoreConfig config;
    private final Object globalLock;
    private DavResource resource;
    private List<AbstractExplorerFileStore> children = new ArrayList<AbstractExplorerFileStore>();
    private boolean refreshable = false;

    WebDavFileStore(String mountID, String path, WebDavFileStoreConfig config, DavResource resource, RemoteExplorerFileStore parent, Object lock) {
        super(Objects.requireNonNull(mountID), Objects.requireNonNull(path));
        this.config = Objects.requireNonNull(config);
        this.resource = resource;
        this.parent = parent;
        this.globalLock = lock;
    }

    public String getRemoteHostID() {
        return null;
    }

    public void copy(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        new MoveOrCopyJob(this, (WebDavFileStore)destination, MoveOrCopyJob.Operation.COPY, this.config.getSardine()).schedule();
    }

    public RemoteDownloadStream openDownloadStream() throws CoreException {
        BuildDownloadStreamJob job = new BuildDownloadStreamJob(this, this.config.getSardine());
        job.schedule();
        return job.getDownloadStream();
    }

    public RemoteUploadStream openWorkflowUploadStream() throws CoreException {
        throw new UnsupportedOperationException("openWorkflowUploadStream is (currently) not supported");
    }

    public RemoteUploadStream openFileUploadStream() throws CoreException {
        throw new UnsupportedOperationException("openFileUploadStream is (currently) not supported");
    }

    public WebDavFileInfo fetchInfo() {
        return new WebDavFileInfo(this.resource);
    }

    public String createSnapshot(String comment) throws CoreException {
        throw new UnsupportedOperationException("snapshots are (currently) not supported");
    }

    public void replaceWithSnapshot(String snapshotName) throws CoreException {
        throw new UnsupportedOperationException("snapshots are (currently) not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        Object object = this.globalLock;
        synchronized (object) {
            this.loadFromWebdav(false);
            return (String[])this.children.stream().map(c -> c.getName()).toArray(String[]::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractExplorerFileStore getChild(String name) {
        Object object = this.globalLock;
        synchronized (object) {
            this.loadFromWebdav(false);
            return this.children.stream().filter(store -> store.getName().equals(name)).findFirst().orElseGet(() -> new WebDavFileStore(this.getMountID(), this.getFullName() + "/" + name, this.config, null, this, this.globalLock));
        }
    }

    public RemoteExplorerFileStore getParent() {
        return this.parent;
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException("openInputStream is (currently) not supported");
    }

    public AbstractExplorerFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        new MkDirJob(this, this.config.getSardine()).schedule();
        return this;
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException("openOutputStream is (currently) not supported");
    }

    public void move(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        new MoveOrCopyJob(this, (WebDavFileStore)destination, MoveOrCopyJob.Operation.MOVE, this.config.getSardine()).schedule();
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        new DeleteJob(this, this.config.getSardine()).schedule();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebDavFileStore)) {
            return false;
        }
        WebDavFileStore other = (WebDavFileStore)((Object)obj);
        return Objects.equals(this.getWebDavUrl(), other.getWebDavUrl());
    }

    public int hashCode() {
        return Objects.hash(this.getWebDavUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.globalLock;
        synchronized (object) {
            this.loadFromWebdav(true);
            AbstractContentProvider contentProvider = this.getContentProvider();
            if (contentProvider != null) {
                contentProvider.refresh((AbstractExplorerFileStore)this);
            }
        }
    }

    public File resolveToLocalFile() throws CoreException {
        try {
            DownloadAndUnzipJob job = new DownloadAndUnzipJob(this, this.config.getSardine());
            job.schedule();
            job.join();
            return job.getDownloadResult();
        }
        catch (InterruptedException e) {
            throw WebDavFileStore.newCoreException("Download interrupted", e);
        }
    }

    public IFileStore getNativeFilestore() {
        return this;
    }

    public URI toURI() {
        try {
            String uriPath = "knime://" + UrlUtils.urlEncodePathComponents((String)(this.getMountID() + "/" + this.config.getUser() + this.getFullName()));
            LOGGER.log("toURI(): %s", uriPath);
            return new URI(uriPath);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    void loadFromWebdav(boolean force) {
        block10: {
            if (this.resource != null && !force) {
                return;
            }
            this.refreshable = true;
            try {
                List resources = this.config.getSardine().list(this.getWebDavUrl(), -1);
                this.children = new ArrayList<AbstractExplorerFileStore>();
                this.resource = (DavResource)resources.get(0);
                for (DavResource resource : resources.subList(1, resources.size())) {
                    String path = WebDavFileStore.stripExtension(WebDavFileStore.trimSpaceAndUserPrefix(resource.getPath()));
                    IPath parentPath = WebDavFileStore.getParentPath(this.getFullName(), path);
                    WebDavFileStore parent = (WebDavFileStore)this.getFileStore(parentPath);
                    parent.children.add((AbstractExplorerFileStore)new WebDavFileStore(this.getMountID(), path, this.config, resource, parent, this.globalLock));
                }
            }
            catch (SardineException e) {
                this.resource = null;
                if (e.getStatusCode() == 404) {
                    this.children = Collections.emptyList();
                } else if (!this.propagateToRoot()) {
                    this.children = e.getStatusCode() == 401 ? this.makeMessage("Could not login with the given credentials.") : this.makeMessage(String.format("Received status code %s.", e.getStatusCode()));
                }
            }
            catch (IOException iOException) {
                this.resource = null;
                if (!this.propagateToRoot()) {
                    this.children = this.makeMessage("Could not connect to NodePit.");
                }
            }
            catch (IllegalArgumentException e) {
                this.resource = null;
                if (this.propagateToRoot()) break block10;
                this.children = this.makeMessage(e.getMessage());
            }
        }
    }

    private boolean propagateToRoot() {
        if (this.getParent() != null) {
            this.getContentProvider().getFileStore("/").refresh();
            return true;
        }
        return false;
    }

    private List<AbstractExplorerFileStore> makeMessage(String message) {
        return Collections.singletonList(this.getMessageFileStore(message));
    }

    public static CoreException newCoreException(String message, Throwable t) {
        return new CoreException((IStatus)WebDavFileStore.makeStatus(message, t));
    }

    public static Status makeStatus(String message, Throwable t) {
        return new Status(4, "com.nodepit.knime.explorer", message, t);
    }

    public void saveJobAsWorkflow(RemoteExplorerFileStore destination) throws CoreException {
        throw new UnsupportedOperationException("saveJobAsWorkflow is (currently) not supported");
    }

    public void cancelExecution() throws CoreException {
        throw new UnsupportedOperationException("cancelExecution is (currently) not supported");
    }

    public Optional<File> resolveToLocalFileConditional(IProgressMonitor pm, ZonedDateTime ifModifiedSince) throws CoreException {
        return Optional.of(this.resolveToLocalFile());
    }

    public Optional<? extends RestLocationInfo> locationInfo() {
        String itemId = URI.create(this.getWebDavUrl()).getPath();
        HubSpaceLocationInfo hubSpaceLocationInfo = ((HubSpaceLocationInfoBuilderFactory.HubSpaceLocationInfoSpaceBuilder)HubSpaceLocationInfoBuilderFactory.create().withRepositoryAddress(URI.create(this.config.getNodePitUrl() + "/space/")).withWorkflowPath("/" + WebDavFileStore.stripExtension(WebDavFileStore.trimSpacePrefix(itemId))).withAuthenticator((Authenticator)new NoOpAuthenticator()).withDefaultMountId(this.getMountID())).withSpace("/", "*private").withWorkflowItemId("*" + itemId).withItemVersion(Integer.valueOf(1)).build();
        LOGGER.log("locationInfo: %s", hubSpaceLocationInfo);
        return Optional.of(hubSpaceLocationInfo);
    }

    public String getExtension() {
        return WebDavFileStore.getExtension((AbstractExplorerFileInfo)this.fetchInfo());
    }

    public static String getExtension(AbstractExplorerFileInfo info) {
        if (info.isWorkflowTemplate()) {
            return ".kntp";
        }
        if (info.isWorkflow()) {
            return ".knwf";
        }
        return "";
    }

    public String getWebDavUrl() {
        Object webDavUrl = this.config.getBaseUrl().replaceAll("/$", "");
        webDavUrl = (String)webDavUrl + UrlUtils.urlEncodePathComponents((String)this.getFullName()).replaceAll("/+", "/");
        webDavUrl = (String)webDavUrl + (this.fetchInfo().isDirectory() ? "/" : this.getExtension());
        return webDavUrl;
    }

    public static String stripExtension(String path) {
        String[] stringArray = NodePitConstants.ALL_FILE_EXTENSIONS;
        int n = NodePitConstants.ALL_FILE_EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            path = path.replaceAll(Pattern.quote(extension) + "$", "");
            ++n2;
        }
        return path;
    }

    boolean isRefreshable() {
        return this.refreshable;
    }

    private static IPath getParentPath(String rootPath, String childPath) {
        IPath parentPath = new Path(childPath).append("..");
        return new Path(parentPath.toString().substring(rootPath.length()));
    }

    static String trimSpaceAndUserPrefix(String path) {
        return path.replaceAll("/space/[^/]+", "");
    }

    static String trimSpacePrefix(String itemId) {
        return itemId.replaceAll("^" + Pattern.quote("/space/"), "");
    }
}

