/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.explorer.jobs;

import com.github.sardine.Sardine;
import com.nodepit.knime.explorer.WebDavFileStore;
import com.nodepit.knime.explorer.jobs.DownloadAndUnzipJob;
import com.nodepit.knime.explorer.utils.ZipUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.knime.core.node.NodeLogger;
import org.knime.workbench.explorer.filesystem.RemoteDownloadStream;

public class BuildDownloadStreamJob
extends Job {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(BuildDownloadStreamJob.class);
    private final WebDavFileStore source;
    private final Sardine sardine;
    private boolean cancelled = false;
    private File zipFile = null;

    public BuildDownloadStreamJob(WebDavFileStore source, Sardine sardine) {
        super("Prepare NodePit import");
        this.source = source;
        this.sardine = sardine;
    }

    /*
     * Loose catch block
     */
    protected IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        File downloadedDirectory;
        block52: {
            downloadedDirectory = null;
            DownloadAndUnzipJob downloadAndUnzipJob = new DownloadAndUnzipJob(this.source, this.sardine);
            downloadAndUnzipJob.schedule();
            downloadAndUnzipJob.join();
            if (monitor != null && monitor.isCanceled()) {
                this.cancelled = true;
                throw new OperationCanceledException();
            }
            downloadedDirectory = downloadAndUnzipJob.getDownloadResult();
            File tempFile = Files.createTempFile("NodePit_" + this.source.getName(), ".zip", new FileAttribute[0]).toFile();
            LOGGER.debugWithFormat("Writing %s", new Object[]{tempFile});
            ZipUtil.zipDirectory(downloadedDirectory, tempFile);
            LOGGER.debugWithFormat("Wrote %s", new Object[]{tempFile});
            this.zipFile = tempFile;
            iStatus = Status.OK_STATUS;
            if (downloadedDirectory == null) break block52;
            try {
                Throwable throwable = null;
                Object var8_17 = null;
                try (Stream<Path> paths = Files.walk(downloadedDirectory.toPath(), new FileVisitOption[0]);){
                    paths.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                LOGGER.debugWithFormat("Could not delete temporary directory %s", new Object[]{downloadedDirectory});
            }
        }
        return iStatus;
        catch (InterruptedException interruptedException) {
            IStatus iStatus2;
            block53: {
                iStatus2 = Status.CANCEL_STATUS;
                if (downloadedDirectory == null) break block53;
                try {
                    Throwable throwable = null;
                    Object var8_19 = null;
                    try (Stream<Path> paths = Files.walk(downloadedDirectory.toPath(), new FileVisitOption[0]);){
                        paths.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    LOGGER.debugWithFormat("Could not delete temporary directory %s", new Object[]{downloadedDirectory});
                }
            }
            return iStatus2;
        }
        catch (IOException e) {
            Status status;
            block54: {
                status = WebDavFileStore.makeStatus("Error while downloading", e);
                if (downloadedDirectory == null) break block54;
                {
                    catch (Throwable throwable) {
                        if (downloadedDirectory != null) {
                            try {
                                Throwable throwable4 = null;
                                Object var8_23 = null;
                                try (Stream<Path> paths = Files.walk(downloadedDirectory.toPath(), new FileVisitOption[0]);){
                                    paths.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                                }
                                catch (Throwable throwable5) {
                                    if (throwable4 == null) {
                                        throwable4 = throwable5;
                                    } else if (throwable4 != throwable5) {
                                        throwable4.addSuppressed(throwable5);
                                    }
                                    throw throwable4;
                                }
                            }
                            catch (IOException iOException) {
                                LOGGER.debugWithFormat("Could not delete temporary directory %s", new Object[]{downloadedDirectory});
                            }
                        }
                        throw throwable;
                    }
                }
                try {
                    Throwable throwable = null;
                    Object var8_21 = null;
                    try (Stream<Path> paths = Files.walk(downloadedDirectory.toPath(), new FileVisitOption[0]);){
                        paths.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                    }
                    catch (Throwable throwable6) {
                        if (throwable == null) {
                            throwable = throwable6;
                        } else if (throwable != throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    LOGGER.debugWithFormat("Could not delete temporary directory %s", new Object[]{downloadedDirectory});
                }
            }
            return status;
        }
    }

    public RemoteDownloadStream getDownloadStream() {
        return new NotSoRemoteDownloadStream();
    }

    private final class NotSoRemoteDownloadStream
    extends RemoteDownloadStream {
        private InputStream stream = null;

        private NotSoRemoteDownloadStream() {
        }

        public List<String> getMessages() {
            return Collections.emptyList();
        }

        public long length() {
            this.throwIfCancelled();
            return BuildDownloadStreamJob.this.zipFile != null ? BuildDownloadStreamJob.this.zipFile.length() : -1L;
        }

        public boolean readyForDownload() {
            this.throwIfCancelled();
            return BuildDownloadStreamJob.this.zipFile != null;
        }

        public int read() throws IOException {
            this.throwIfCancelled();
            return this.getStream().read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            this.throwIfCancelled();
            return this.getStream().read(b, off, len);
        }

        private void throwIfCancelled() {
            if (BuildDownloadStreamJob.this.cancelled) {
                throw new IllegalStateException("The download was cancelled.");
            }
        }

        public void close() throws IOException {
            try {
                if (this.getStream() != null) {
                    this.getStream().close();
                }
            }
            catch (Throwable throwable) {
                if (BuildDownloadStreamJob.this.zipFile != null) {
                    BuildDownloadStreamJob.this.zipFile.delete();
                    LOGGER.debugWithFormat("deleted temp file %s", new Object[]{BuildDownloadStreamJob.this.zipFile});
                }
                throw throwable;
            }
            if (BuildDownloadStreamJob.this.zipFile != null) {
                BuildDownloadStreamJob.this.zipFile.delete();
                LOGGER.debugWithFormat("deleted temp file %s", new Object[]{BuildDownloadStreamJob.this.zipFile});
            }
        }

        private InputStream getStream() throws IOException {
            if (this.stream != null) {
                return this.stream;
            }
            if (BuildDownloadStreamJob.this.zipFile != null) {
                this.stream = new FileInputStream(BuildDownloadStreamJob.this.zipFile);
                return this.stream;
            }
            throw new IllegalStateException("File does not yet exist");
        }
    }
}

