/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.explorer.utils;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public final class Lazy<T> {
    private final AtomicReference<T> instance = new AtomicReference();
    private final Supplier<T> supplier;

    public Lazy(Supplier<T> supplier) {
        this.supplier = Objects.requireNonNull(supplier);
    }

    public T get() {
        T value = this.instance.get();
        if (value == null && !this.instance.compareAndSet(null, value = this.supplier.get())) {
            value = this.instance.get();
        }
        return value;
    }
}

