/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.annotate2;

import com.nodepit.annotate2.Annotator2NodeSettings;
import com.nodepit.utils.AnnotatorUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import org.knime.core.node.port.flowvariable.FlowVariablePortObject;
import org.knime.core.node.port.flowvariable.FlowVariablePortObjectSpec;
import org.knime.core.node.workflow.FlowVariable;
import org.knime.core.node.workflow.NodeContainer;
import org.knime.core.node.workflow.NodeContainerParent;
import org.knime.core.node.workflow.NodeContext;
import org.knime.core.node.workflow.NodeID;
import org.knime.core.node.workflow.SubNodeContainer;
import org.knime.core.node.workflow.VariableType;
import org.knime.core.node.workflow.WorkflowManager;

class Annotator2NodeModel
extends NodeModel {
    private static final String CURRENT_WF_PLACEHOLDER = "$";
    private static final Pattern FLOW_VARIABLE_PATTERN = Pattern.compile("\\{\\{([^}$]+)\\}\\}");
    private final Annotator2NodeSettings nodeSettings = new Annotator2NodeSettings();

    protected Annotator2NodeModel() {
        super(new PortType[]{FlowVariablePortObject.TYPE_OPTIONAL}, new PortType[]{FlowVariablePortObject.TYPE});
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        this.nonPortableIdWarning();
        String message = this.assignFlowVariables(this.nodeSettings.message.getStringValue());
        this.annotate(message);
        return new PortObject[]{FlowVariablePortObject.INSTANCE};
    }

    private String assignFlowVariables(String message) {
        Map flowVariables = this.getAvailableInputFlowVariables((VariableType)VariableType.BooleanType.INSTANCE, new VariableType[]{VariableType.DoubleType.INSTANCE, VariableType.IntType.INSTANCE, VariableType.LongType.INSTANCE, VariableType.StringType.INSTANCE});
        Matcher matcher = FLOW_VARIABLE_PATTERN.matcher(message);
        StringBuilder replaceBuilder = new StringBuilder();
        LinkedHashSet<String> missingVariables = new LinkedHashSet<String>();
        while (matcher.find()) {
            String variableName = matcher.group(1);
            FlowVariable replaceValue = (FlowVariable)flowVariables.get(variableName);
            if (replaceValue == null) {
                missingVariables.add(variableName);
                continue;
            }
            matcher.appendReplacement(replaceBuilder, replaceValue.getValueAsString());
        }
        matcher.appendTail(replaceBuilder);
        if (!missingVariables.isEmpty()) {
            this.setWarningMessage("Missing flow variable(s): " + String.join((CharSequence)", ", missingVariables));
        }
        return replaceBuilder.toString();
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        this.nonPortableIdWarning();
        this.assignFlowVariables(this.nodeSettings.message.getStringValue());
        return new PortObjectSpec[]{FlowVariablePortObjectSpec.INSTANCE};
    }

    private void nonPortableIdWarning() {
        if (AnnotationTargets.fromLabel(this.nodeSettings.target.getStringValue()) == AnnotationTargets.NODE_ID && !this.nodeSettings.nodeId.getStringValue().startsWith(CURRENT_WF_PLACEHOLDER)) {
            this.setWarningMessage("Non-portable Node ID \u2013 please refer to the node documentation.");
        }
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettings(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadSettings(settings);
    }

    protected void reset() {
        if (!this.nodeSettings.keepOnReset.getBooleanValue()) {
            try {
                this.annotate("");
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    private void annotate(String message) {
        NodeContext nodeContext = NodeContext.getContext();
        NodeContainer nodeContainer = nodeContext.getNodeContainer();
        if (nodeContainer == null) {
            throw new IllegalStateException("nodeContainer == null");
        }
        AnnotationTargets target = AnnotationTargets.fromLabel(this.nodeSettings.target.getStringValue());
        target.annotate(message, nodeContainer, this.nodeSettings);
    }

    static enum AnnotationTargets {
        CURRENT("Current Node"){

            @Override
            public void annotate(String message, NodeContainer nodeContainer, Annotator2NodeSettings nodeSettings) {
                AnnotatorUtils.writeAnnotation(message, nodeContainer);
            }
        }
        ,
        PARENT("Parent Node"){

            @Override
            public void annotate(String message, NodeContainer nodeContainer, Annotator2NodeSettings nodeSettings) {
                NodeContainerParent parent = nodeContainer.getDirectNCParent();
                if (parent.getDirectNCParent() instanceof SubNodeContainer) {
                    parent = parent.getDirectNCParent();
                }
                if (parent.getDirectNCParent() == WorkflowManager.ROOT) {
                    throw new IllegalStateException("Node does not have a parent.");
                }
                if (!(parent instanceof NodeContainer)) {
                    throw new IllegalStateException("!(parent instanceof NodeContainer)");
                }
                AnnotatorUtils.writeAnnotation(message, (NodeContainer)parent);
            }
        }
        ,
        NODE_ID("Node ID"){

            @Override
            public void annotate(String message, NodeContainer nodeContainer, Annotator2NodeSettings nodeSettings) {
                NodeContainerParent parent;
                String currentIdStr = nodeContainer.getID().toString();
                String currentWorkflowId = currentIdStr.substring(0, currentIdStr.indexOf(58));
                String nodeIdToAnnotate = nodeSettings.nodeId.getStringValue();
                String replacedNodeIdToAnnotate = nodeIdToAnnotate.replace(Annotator2NodeModel.CURRENT_WF_PLACEHOLDER, currentWorkflowId);
                for (parent = nodeContainer.getDirectNCParent(); parent != WorkflowManager.ROOT; parent = parent.getDirectNCParent()) {
                }
                if (!(parent instanceof NodeContainer)) {
                    throw new IllegalStateException("!(parent instanceof WorkflowManager)");
                }
                WorkflowManager workflowManager = (WorkflowManager)parent;
                NodeContainer currentContainer = workflowManager.findNodeContainer(NodeID.fromString((String)replacedNodeIdToAnnotate));
                AnnotatorUtils.writeAnnotation(message, currentContainer);
            }
        };

        private final String label;

        private AnnotationTargets(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }

        public static String[] labels() {
            return (String[])Arrays.stream(AnnotationTargets.values()).map(target -> target.label).toArray(String[]::new);
        }

        public static AnnotationTargets fromLabel(String label) {
            return Arrays.stream(AnnotationTargets.values()).filter(target -> target.label.equals(label)).findFirst().orElseThrow(() -> new IllegalArgumentException("No such target: " + label));
        }

        public abstract void annotate(String var1, NodeContainer var2, Annotator2NodeSettings var3);
    }
}

