/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.annotaterowcount;

import com.nodepit.annotaterowcount.AnnotateRowCountNodeSettings;
import com.nodepit.utils.AnnotatorUtils;
import java.io.File;
import java.io.IOException;
import org.knime.core.data.DataTableSpec;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortType;
import org.knime.core.node.workflow.NodeContainer;
import org.knime.core.node.workflow.NodeContext;

class AnnotateRowCountNodeModel
extends NodeModel {
    private final AnnotateRowCountNodeSettings nodeSettings;

    protected AnnotateRowCountNodeModel(PortType[] portTypes) {
        super(portTypes, portTypes);
        this.nodeSettings = new AnnotateRowCountNodeSettings(portTypes.length);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        StringBuilder annotation = new StringBuilder();
        int i = 0;
        while (i < inData.length) {
            BufferedDataTable table = inData[i];
            annotation.append(this.nodeSettings.getAnnotation(table, i));
            ++i;
        }
        this.annotate(annotation.toString());
        return inData;
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        return inSpecs;
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettings(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadSettings(settings);
    }

    protected void reset() {
        this.annotate("");
    }

    private void annotate(String message) {
        NodeContext nodeContext = NodeContext.getContext();
        NodeContainer nodeContainer = nodeContext.getNodeContainer();
        if (nodeContainer == null) {
            throw new IllegalStateException("nodeContainer == null");
        }
        AnnotatorUtils.writeAnnotation(message, nodeContainer);
    }
}

