/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.annotaterowcount;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;

class AnnotateRowCountNodeSettings {
    private final List<SettingsModelString> tableNameSettings = new ArrayList<SettingsModelString>();

    AnnotateRowCountNodeSettings(int numTables) {
        int i = 0;
        while (i < numTables) {
            this.tableNameSettings.add(new SettingsModelString("tableName_" + i, numTables > 1 ? "Input " + i + ": " : ""));
            ++i;
        }
    }

    SettingsModelString getDialogNameSetting(int i) {
        return this.tableNameSettings.get(i);
    }

    void saveSettings(NodeSettingsWO settings) {
        for (SettingsModelString settingsModel : this.tableNameSettings) {
            settingsModel.saveSettingsTo(settings);
        }
    }

    void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        for (SettingsModelString settingsModel : this.tableNameSettings) {
            settingsModel.validateSettings(settings);
        }
    }

    void loadSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        for (SettingsModelString settingsModel : this.tableNameSettings) {
            settingsModel.loadSettingsFrom(settings);
        }
    }

    String getAnnotation(BufferedDataTable table, int i) {
        SettingsModelString setting = this.tableNameSettings.get(i);
        return String.format(Locale.ROOT, "%s%,d rows\n", setting.getStringValue(), table.size());
    }
}

