/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.annotate2;

import com.nodepit.annotate2.Annotator2NodeModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;

class Annotator2NodeSettings {
    private static final String HAIKU = "old pond\nfrog leaps in\nwater\u2019s sound";
    final SettingsModelString message = new SettingsModelString("message", "old pond\nfrog leaps in\nwater\u2019s sound");
    final SettingsModelString target = new SettingsModelString("target", Annotator2NodeModel.AnnotationTargets.CURRENT.toString());
    final SettingsModelString nodeId = new SettingsModelString("nodeId", null);
    final SettingsModelBoolean keepOnReset = new SettingsModelBoolean("keepOnReset", false);

    Annotator2NodeSettings() {
        this.target.addChangeListener(l -> this.updateEnabled());
        this.updateEnabled();
    }

    private void updateEnabled() {
        this.nodeId.setEnabled(Annotator2NodeModel.AnnotationTargets.fromLabel(this.target.getStringValue()) == Annotator2NodeModel.AnnotationTargets.NODE_ID);
    }

    void saveSettings(NodeSettingsWO settings) {
        this.message.saveSettingsTo(settings);
        this.target.saveSettingsTo(settings);
        this.nodeId.saveSettingsTo(settings);
        this.keepOnReset.saveSettingsTo(settings);
    }

    void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.message.validateSettings(settings);
        this.target.validateSettings(settings);
        this.nodeId.validateSettings(settings);
        try {
            this.keepOnReset.validateSettings(settings);
        }
        catch (InvalidSettingsException invalidSettingsException) {}
    }

    void loadSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.message.loadSettingsFrom(settings);
        this.target.loadSettingsFrom(settings);
        this.nodeId.loadSettingsFrom(settings);
        try {
            this.keepOnReset.loadSettingsFrom(settings);
        }
        catch (InvalidSettingsException invalidSettingsException) {}
    }
}

