/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.annotateworkflow;

import com.nodepit.annotateworkflow.AnnotateWorkflowNodeSettings;
import com.nodepit.utils.AnnotatorUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.Node;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettings;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.workflow.FlowVariable;
import org.knime.core.node.workflow.NativeNodeContainer;
import org.knime.core.node.workflow.NodeContainer;
import org.knime.core.node.workflow.NodeContainerOutPort;
import org.knime.core.node.workflow.NodeContext;
import org.knime.core.node.workflow.NodeID;
import org.knime.core.node.workflow.WorkflowManager;

class AnnotateWorkflowNodeModel
extends NodeModel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(AnnotateWorkflowNodeModel.class);
    private final AnnotateWorkflowNodeSettings nodeSettings = new AnnotateWorkflowNodeSettings();

    protected AnnotateWorkflowNodeModel() {
        super(0, 0);
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        Map<String, SettingsGetter> mappings = AnnotateWorkflowNodeModel.getMappings();
        WorkflowManager workflowManager = NodeContext.getContext().getWorkflowManager();
        Map nodes = workflowManager.findNodes(NodeModel.class, true);
        for (Map.Entry nodeEntry : nodes.entrySet()) {
            Optional<FlowVariable> nodeAnnotationFv;
            NodeContainer nodeContainer;
            try {
                nodeContainer = workflowManager.findNodeContainer((NodeID)nodeEntry.getKey());
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn((Object)("Encountered IllegalArgumentException for " + nodeEntry.getKey()), (Throwable)e);
                continue;
            }
            if (!(nodeContainer instanceof NativeNodeContainer)) continue;
            NativeNodeContainer nativeNodeContainer = (NativeNodeContainer)nodeContainer;
            Node node = nativeNodeContainer.getNode();
            String annotation = null;
            NodeModel nodeModel = node.getNodeModel();
            Optional<Method> getNodeAnnotationMethod = AnnotateWorkflowNodeModel.getNodeAnnotationMethod(nodeModel);
            if (getNodeAnnotationMethod.isPresent()) {
                try {
                    annotation = (String)getNodeAnnotationMethod.get().invoke((Object)nodeModel, new Object[0]);
                }
                catch (Exception e) {
                    LOGGER.warn((Object)"Exception when calling getNodeAnnotation()", (Throwable)e);
                }
            }
            if ((nodeAnnotationFv = AnnotateWorkflowNodeModel.getNodeAnnotationFlowVar((NodeID)nodeEntry.getKey(), nodeModel)).isPresent()) {
                annotation = nodeAnnotationFv.get().getValueAsString();
            }
            if (annotation == null) {
                String factoryName = node.getFactory().getClass().getName();
                SettingsGetter settingsGetter = mappings.get(factoryName);
                if (settingsGetter == null) {
                    LOGGER.infoWithFormat("No annotation mapping defined for %s", new Object[]{factoryName});
                    continue;
                }
                try {
                    NodeSettings nodeSettings = nodeContainer.getNodeSettings().getNodeSettings("model");
                    annotation = settingsGetter.getValue(new SettingsGetterArgs(nodeSettings, nativeNodeContainer));
                }
                catch (InvalidSettingsException e) {
                    LOGGER.info((Object)("Encountered InvalidSettingsException for " + factoryName), (Throwable)e);
                }
            }
            AnnotatorUtils.writeAnnotation(annotation != null ? annotation : "", nodeContainer);
        }
        return new PortObject[0];
    }

    private static Optional<Method> getNodeAnnotationMethod(NodeModel nodeModel) {
        return Arrays.stream(nodeModel.getClass().getMethods()).filter(m -> "getNodeAnnotation".equals(m.getName()) && m.getExceptionTypes().length == 0 && m.getParameterCount() == 0 && m.getReturnType().equals(String.class)).findFirst();
    }

    private static Optional<FlowVariable> getNodeAnnotationFlowVar(NodeID nodeID, NodeModel nodeModel) {
        FlowVariable nodeAnnotationFv = (FlowVariable)nodeModel.getAvailableFlowVariables().get("_nodeAnnotation_");
        if (nodeAnnotationFv != null && nodeAnnotationFv.getOwner().equals((Object)nodeID)) {
            return Optional.of(nodeAnnotationFv);
        }
        return Optional.empty();
    }

    private static Map<String, SettingsGetter> getMappings() {
        HashMap<String, SettingsGetter> MAPPINGS = new HashMap<String, SettingsGetter>();
        MAPPINGS.put("org.knime.base.node.preproc.stringmanipulation.StringManipulationNodeFactory", args -> args.settings.getString("expression"));
        MAPPINGS.put("org.knime.base.node.io.tablecreator.TableCreator2NodeFactory", args -> "Rows: " + args.settings.getNodeSettings("rowIndices").getInt("array-size"));
        MAPPINGS.put("org.knime.base.node.preproc.sorter.SorterNodeFactory", args -> {
            NodeSettings incllist = args.settings.getNodeSettings("incllist");
            NodeSettings sortOrder = args.settings.getNodeSettings("sortOrder");
            int arraySize = incllist.getInt("array-size");
            StringBuilder result = new StringBuilder();
            int idx = 0;
            while (idx < arraySize) {
                String key = incllist.getString("" + idx);
                boolean order = sortOrder.getBoolean("" + idx);
                result.append(key).append(" ").append(order ? "asc" : "desc").append("\n");
                ++idx;
            }
            return result.toString();
        });
        MAPPINGS.put("org.knime.base.node.preproc.groupby.GroupByNodeFactory", args -> {
            NodeSettings incllist = args.settings.getNodeSettings("grouByColumns").getNodeSettings("InclList");
            int arraySize = incllist.getInt("array-size");
            StringBuilder result = new StringBuilder();
            int idx = 0;
            while (idx < arraySize) {
                String key = incllist.getString("" + idx);
                result.append(key).append("\n");
                ++idx;
            }
            return result.toString();
        });
        MAPPINGS.put("org.knime.base.node.io.filehandling.csv.reader.CSVTableReaderNodeFactory", args -> {
            String path = args.settings.getNodeSettings("settings").getNodeSettings("file_selection").getNodeSettings("path").getString("path");
            return path.substring(path.lastIndexOf(47) + 1);
        });
        MAPPINGS.put("org.knime.base.node.io.filehandling.csv.writer.CSVWriter2NodeFactory", args -> {
            String path = args.settings.getNodeSettings("settings").getNodeSettings("file_chooser_settings").getNodeSettings("path").getString("path");
            return path.substring(path.lastIndexOf(47) + 1);
        });
        MAPPINGS.put("org.knime.base.node.preproc.tablediff.TableDifferNodeFactory", args -> {
            NodeContainerOutPort outPort = (NodeContainerOutPort)args.container.getOutPort(1);
            BufferedDataTable bufferedDataTable = (BufferedDataTable)outPort.getPortObject();
            return bufferedDataTable != null ? String.valueOf(bufferedDataTable.size()) + " differences" : null;
        });
        SettingsGetter expressionsMapping = args -> {
            NodeSettings expressions = args.settings.getNodeSettings("expressions");
            int count = args.settings.getInt("count");
            StringBuilder result = new StringBuilder();
            int idx = 0;
            while (idx < count) {
                NodeSettings element = expressions.getNodeSettings("element " + idx);
                String expression = element.getString("expression");
                String output = element.getString("outputName");
                result.append(output).append(": ").append(expression).append("\n");
                ++idx;
            }
            return result.toString();
        };
        MAPPINGS.put("org.knime.expressions.base.node.formulas.FormulasNodeFactory", expressionsMapping);
        MAPPINGS.put("org.knime.expressions.base.node.variableexpression.VariableExpressionsNodeFactory", expressionsMapping);
        return MAPPINGS;
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        return new PortObjectSpec[0];
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettings(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadSettings(settings);
    }

    protected void reset() {
        if (!this.nodeSettings.keepOnReset.getBooleanValue()) {
            WorkflowManager workflowManager = NodeContext.getContext().getWorkflowManager();
            Map nodes = workflowManager.findNodes(NodeModel.class, true);
            for (Map.Entry nodeEntry : nodes.entrySet()) {
                NodeContainer nodeContainer;
                try {
                    nodeContainer = workflowManager.findNodeContainer((NodeID)nodeEntry.getKey());
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn((Object)("Encountered IllegalArgumentException for " + nodeEntry.getKey()), (Throwable)e);
                    continue;
                }
                if (!(nodeContainer instanceof NativeNodeContainer)) continue;
                NativeNodeContainer nativeNodeContainer = (NativeNodeContainer)nodeContainer;
                Node node = nativeNodeContainer.getNode();
                String factoryName = node.getFactory().getClass().getName();
                SettingsGetter settingsGetter = AnnotateWorkflowNodeModel.getMappings().get(factoryName);
                if (settingsGetter == null && AnnotateWorkflowNodeModel.getNodeAnnotationMethod(node.getNodeModel()).isEmpty() && AnnotateWorkflowNodeModel.getNodeAnnotationFlowVar((NodeID)nodeEntry.getKey(), node.getNodeModel()).isEmpty()) continue;
                AnnotatorUtils.writeAnnotation("", nodeContainer);
            }
        }
    }

    private static interface SettingsGetter {
        public String getValue(SettingsGetterArgs var1) throws InvalidSettingsException;
    }

    private static class SettingsGetterArgs {
        final NodeSettings settings;
        final NativeNodeContainer container;

        SettingsGetterArgs(NodeSettings settings, NativeNodeContainer container) {
            this.settings = settings;
            this.container = container;
        }
    }
}

