/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.reset;

import java.io.File;
import java.io.IOException;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import org.knime.core.node.port.flowvariable.FlowVariablePortObject;
import org.knime.core.node.port.flowvariable.FlowVariablePortObjectSpec;
import org.knime.core.node.workflow.NodeContainer;
import org.knime.core.node.workflow.NodeContainerParent;
import org.knime.core.node.workflow.NodeContext;
import org.knime.core.node.workflow.NodeID;
import org.knime.core.node.workflow.WorkflowManager;

final class ResetOnLoadNodeModel
extends NodeModel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(ResetOnLoadNodeModel.class);

    ResetOnLoadNodeModel() {
        super(new PortType[0], new PortType[]{FlowVariablePortObject.TYPE});
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        return new PortObject[]{FlowVariablePortObject.INSTANCE};
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        return new PortObjectSpec[]{FlowVariablePortObjectSpec.INSTANCE};
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.resetNodeThread();
    }

    private void resetNodeThread() {
        NodeContext nodeContext = NodeContext.getContext();
        new Thread(() -> {
            LOGGER.info((Object)"Resetting node on load");
            try {
                NodeContainer nodeContainer = nodeContext.getNodeContainer();
                if (nodeContainer == null) {
                    throw new IllegalStateException("nodeContainer == null");
                }
                NodeContainerParent parent = nodeContainer.getDirectNCParent();
                if (!(parent instanceof WorkflowManager)) {
                    throw new IllegalStateException("!(parent instanceof WorkflowManager)");
                }
                WorkflowManager workflowManager = (WorkflowManager)parent;
                workflowManager.findNodes(ResetOnLoadNodeModel.class, false).entrySet().stream().filter(entry -> entry.getValue() == this).map(entry -> (NodeID)entry.getKey()).findFirst().ifPresent(nodeId -> {
                    if (nodeContainer.getNodeContainerState().isExecuted()) {
                        workflowManager.resetAndConfigureNode(nodeId);
                    }
                });
            }
            catch (Exception e) {
                LOGGER.warn((Object)"Error while trying to reset the node", (Throwable)e);
            }
        }).start();
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
    }

    protected void reset() {
    }
}

