/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.utils;

import java.util.Arrays;
import org.knime.core.node.workflow.AnnotationData;
import org.knime.core.node.workflow.NodeAnnotation;
import org.knime.core.node.workflow.NodeAnnotationData;
import org.knime.core.node.workflow.NodeContainer;

public final class AnnotatorUtils {
    private static final int PX_PER_LINE = 16;
    private static final int PX_PER_CHARACTER = 10;

    public static void writeAnnotation(String message, NodeContainer container) {
        NodeAnnotation nodeAnnotation = container.getNodeAnnotation();
        String[] lines = message.split("\n");
        int maxCharsNew = Arrays.stream(lines).map(String::length).max(Integer::compare).orElse(1);
        int numLinesNew = Math.max(1, lines.length);
        NodeAnnotationData newAnnotation = nodeAnnotation.getData().clone();
        newAnnotation.setText(message);
        newAnnotation.setWidth(maxCharsNew * 10);
        newAnnotation.setHeight(numLinesNew * 16);
        newAnnotation.setStyleRanges(new AnnotationData.StyleRange[0]);
        nodeAnnotation.copyFrom((AnnotationData)newAnnotation, true);
    }

    private AnnotatorUtils() {
    }
}

