/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.ocrspace.v1.operation.ocrforremotefile;

import com.nodepit.nodes.ocrspace.v1.ResponseMapper;
import com.nodepit.nodes.ocrspace.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class OCRForRemoteFileNodeSettings {
    private static final String URL_KEY = "url";
    private static final String URL_DEFAULT_VALUE = null;
    private String url = URL_DEFAULT_VALUE;
    static final String[] LANGUAGE_VALUES = new String[]{"ara", "bul", "chs", "cht", "hrv", "cze", "dan", "dut", "eng", "fin", "fre", "ger", "gre", "hun", "kor", "ita", "jpn", "pol", "por", "rus", "slv", "spa", "swe", "tur", "hin", "kan", "per", "tel", "tam", "tai", "vie"};
    private static final String LANGUAGE_KEY = "language";
    private static final String LANGUAGE_DEFAULT_VALUE = "eng";
    private String language = "eng";
    private static final String LANGUAGE_ENABLED_KEY = "languageEnabled";
    private boolean languageEnabled = false;
    private static final String IS_OVERLAY_REQUIRED_KEY = "isOverlayRequired";
    private static final boolean IS_OVERLAY_REQUIRED_DEFAULT_VALUE = false;
    private boolean isOverlayRequired = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    OCRForRemoteFileNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(URL_KEY, this.url);
        settings.addString(LANGUAGE_KEY, this.language);
        settings.addBoolean(LANGUAGE_ENABLED_KEY, this.languageEnabled);
        settings.addBoolean(IS_OVERLAY_REQUIRED_KEY, this.isOverlayRequired);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.url = settings.getString(URL_KEY, URL_DEFAULT_VALUE);
        this.language = settings.getString(LANGUAGE_KEY, LANGUAGE_DEFAULT_VALUE);
        this.languageEnabled = settings.getBoolean(LANGUAGE_ENABLED_KEY, false);
        this.isOverlayRequired = settings.getBoolean(IS_OVERLAY_REQUIRED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.url == null || this.url.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cUrl\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String url() {
        return this.url;
    }

    void url(String value) {
        this.url = value;
    }

    String language() {
        return this.language;
    }

    void language(String value) {
        this.language = value;
    }

    boolean languageEnabled() {
        return this.languageEnabled;
    }

    void languageEnabled(boolean value) {
        this.languageEnabled = value;
    }

    boolean isOverlayRequired() {
        return this.isOverlayRequired;
    }

    void isOverlayRequired(boolean value) {
        this.isOverlayRequired = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

