/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.ocrspace.v1.operation.ocrforlocalfile;

import com.nodepit.nodes.ocrspace.v1.FilePicker;
import com.nodepit.nodes.ocrspace.v1.LabelButton;
import com.nodepit.nodes.ocrspace.v1.ResponseMapper;
import com.nodepit.nodes.ocrspace.v1.operation.ocrforlocalfile.OCRForLocalFileNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class OCRForLocalFileNodeDialog
extends NodeDialogPane {
    private final OCRForLocalFileNodeSettings nodeSettings = new OCRForLocalFileNodeSettings();
    private FilePicker file;
    private JComboBox<String> language;
    private JCheckBox languageEnabled;
    private JCheckBox isOverlayRequired;
    private JComboBox<String> filetype;
    private JCheckBox filetypeEnabled;
    private JCheckBox detectOrientation;
    private JCheckBox isCreateSearchablePdf;
    private JCheckBox isSearchablePdfHideTextLayer;
    private JCheckBox scale;
    private JCheckBox isTable;
    private JComboBox<String> oCREngine;
    private JComboBox<ResponseMapper> resultFormat;

    OCRForLocalFileNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("File:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.file = new FilePicker();
        panel.add((Component)this.file, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Language:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.languageEnabled = new JCheckBox();
        this.languageEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.languageEnabled.setSelected(!this.languageEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.languageEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.language = new JComboBox<String>(OCRForLocalFileNodeSettings.LANGUAGE_VALUES);
        panel.add(this.language, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Is Overlay Required:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.isOverlayRequired = new JCheckBox("true");
        panel.add((Component)this.isOverlayRequired, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label3 = new LabelButton("Filetype:");
        panel.add((Component)label3, c);
        ++c.gridx;
        c.anchor = 17;
        this.filetypeEnabled = new JCheckBox();
        this.filetypeEnabled.addActionListener(e -> this.updateComponents());
        label3.addActionListener(e -> {
            this.filetypeEnabled.setSelected(!this.filetypeEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.filetypeEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.filetype = new JComboBox<String>(OCRForLocalFileNodeSettings.FILETYPE_VALUES);
        panel.add(this.filetype, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label4 = new LabelButton("Detect Orientation:");
        panel.add((Component)label4, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.detectOrientation = new JCheckBox("true");
        panel.add((Component)this.detectOrientation, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label5 = new LabelButton("Is Create Searchable Pdf:");
        panel.add((Component)label5, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.isCreateSearchablePdf = new JCheckBox("true");
        panel.add((Component)this.isCreateSearchablePdf, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label6 = new LabelButton("Is Searchable Pdf Hide Text Layer:");
        panel.add((Component)label6, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.isSearchablePdfHideTextLayer = new JCheckBox("true");
        panel.add((Component)this.isSearchablePdfHideTextLayer, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label7 = new LabelButton("Scale:");
        panel.add((Component)label7, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.scale = new JCheckBox("true");
        panel.add((Component)this.scale, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label8 = new LabelButton("Is Table:");
        panel.add((Component)label8, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.isTable = new JCheckBox("true");
        panel.add((Component)this.isTable, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label9 = new LabelButton("OCR Engine:");
        panel.add((Component)label9, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.oCREngine = new JComboBox<String>(OCRForLocalFileNodeSettings.OCR_ENGINE_VALUES);
        panel.add(this.oCREngine, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(OCRForLocalFileNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.language.setEnabled(this.languageEnabled.isSelected());
        this.filetype.setEnabled(this.filetypeEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.file(this.file.getFile());
        this.nodeSettings.language((String)this.language.getSelectedItem());
        this.nodeSettings.languageEnabled(this.languageEnabled.isSelected());
        this.nodeSettings.isOverlayRequired(this.isOverlayRequired.isSelected());
        this.nodeSettings.filetype((String)this.filetype.getSelectedItem());
        this.nodeSettings.filetypeEnabled(this.filetypeEnabled.isSelected());
        this.nodeSettings.detectOrientation(this.detectOrientation.isSelected());
        this.nodeSettings.isCreateSearchablePdf(this.isCreateSearchablePdf.isSelected());
        this.nodeSettings.isSearchablePdfHideTextLayer(this.isSearchablePdfHideTextLayer.isSelected());
        this.nodeSettings.scale(this.scale.isSelected());
        this.nodeSettings.isTable(this.isTable.isSelected());
        this.nodeSettings.oCREngine((String)this.oCREngine.getSelectedItem());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.file.setFile(this.nodeSettings.file());
        this.language.setSelectedItem(this.nodeSettings.language());
        this.languageEnabled.setSelected(this.nodeSettings.languageEnabled());
        this.isOverlayRequired.setSelected(this.nodeSettings.isOverlayRequired());
        this.filetype.setSelectedItem(this.nodeSettings.filetype());
        this.filetypeEnabled.setSelected(this.nodeSettings.filetypeEnabled());
        this.detectOrientation.setSelected(this.nodeSettings.detectOrientation());
        this.isCreateSearchablePdf.setSelected(this.nodeSettings.isCreateSearchablePdf());
        this.isSearchablePdfHideTextLayer.setSelected(this.nodeSettings.isSearchablePdfHideTextLayer());
        this.scale.setSelected(this.nodeSettings.scale());
        this.isTable.setSelected(this.nodeSettings.isTable());
        this.oCREngine.setSelectedItem(this.nodeSettings.oCREngine());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

