/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.ocrspace.v1.operation.ocrforlocalfile;

import com.nodepit.nodes.ocrspace.v1.ResponseMapper;
import com.nodepit.nodes.ocrspace.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class OCRForLocalFileNodeSettings {
    private static final String FILE_KEY = "file";
    private static final String FILE_DEFAULT_VALUE = null;
    private String file = FILE_DEFAULT_VALUE;
    static final String[] LANGUAGE_VALUES = new String[]{"ara", "bul", "chs", "cht", "hrv", "cze", "dan", "dut", "eng", "fin", "fre", "ger", "gre", "hun", "kor", "ita", "jpn", "pol", "por", "rus", "slv", "spa", "swe", "tur", "hin", "kan", "per", "tel", "tam", "tai", "vie"};
    private static final String LANGUAGE_KEY = "language";
    private static final String LANGUAGE_DEFAULT_VALUE = "eng";
    private String language = "eng";
    private static final String LANGUAGE_ENABLED_KEY = "languageEnabled";
    private boolean languageEnabled = false;
    private static final String IS_OVERLAY_REQUIRED_KEY = "isOverlayRequired";
    private static final boolean IS_OVERLAY_REQUIRED_DEFAULT_VALUE = false;
    private boolean isOverlayRequired = false;
    static final String[] FILETYPE_VALUES = new String[]{"PDF", "GIF", "PNG", "JPG", "TIF", "BMP"};
    private static final String FILETYPE_KEY = "filetype";
    private static final String FILETYPE_DEFAULT_VALUE = FILETYPE_VALUES[0];
    private String filetype = FILETYPE_DEFAULT_VALUE;
    private static final String FILETYPE_ENABLED_KEY = "filetypeEnabled";
    private boolean filetypeEnabled = false;
    private static final String DETECT_ORIENTATION_KEY = "detectOrientation";
    private static final boolean DETECT_ORIENTATION_DEFAULT_VALUE = false;
    private boolean detectOrientation = false;
    private static final String IS_CREATE_SEARCHABLE_PDF_KEY = "isCreateSearchablePdf";
    private static final boolean IS_CREATE_SEARCHABLE_PDF_DEFAULT_VALUE = false;
    private boolean isCreateSearchablePdf = false;
    private static final String IS_SEARCHABLE_PDF_HIDE_TEXT_LAYER_KEY = "isSearchablePdfHideTextLayer";
    private static final boolean IS_SEARCHABLE_PDF_HIDE_TEXT_LAYER_DEFAULT_VALUE = false;
    private boolean isSearchablePdfHideTextLayer = false;
    private static final String SCALE_KEY = "scale";
    private static final boolean SCALE_DEFAULT_VALUE = false;
    private boolean scale = false;
    private static final String IS_TABLE_KEY = "isTable";
    private static final boolean IS_TABLE_DEFAULT_VALUE = false;
    private boolean isTable = false;
    static final String[] OCR_ENGINE_VALUES = new String[]{"1", "2", "3", "4"};
    private static final String OCR_ENGINE_KEY = "oCREngine";
    private static final String OCR_ENGINE_DEFAULT_VALUE = "1";
    private String oCREngine = "1";
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    OCRForLocalFileNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(FILE_KEY, this.file);
        settings.addString(LANGUAGE_KEY, this.language);
        settings.addBoolean(LANGUAGE_ENABLED_KEY, this.languageEnabled);
        settings.addBoolean(IS_OVERLAY_REQUIRED_KEY, this.isOverlayRequired);
        settings.addString(FILETYPE_KEY, this.filetype);
        settings.addBoolean(FILETYPE_ENABLED_KEY, this.filetypeEnabled);
        settings.addBoolean(DETECT_ORIENTATION_KEY, this.detectOrientation);
        settings.addBoolean(IS_CREATE_SEARCHABLE_PDF_KEY, this.isCreateSearchablePdf);
        settings.addBoolean(IS_SEARCHABLE_PDF_HIDE_TEXT_LAYER_KEY, this.isSearchablePdfHideTextLayer);
        settings.addBoolean(SCALE_KEY, this.scale);
        settings.addBoolean(IS_TABLE_KEY, this.isTable);
        settings.addString(OCR_ENGINE_KEY, this.oCREngine);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.file = settings.getString(FILE_KEY, FILE_DEFAULT_VALUE);
        this.language = settings.getString(LANGUAGE_KEY, LANGUAGE_DEFAULT_VALUE);
        this.languageEnabled = settings.getBoolean(LANGUAGE_ENABLED_KEY, false);
        this.isOverlayRequired = settings.getBoolean(IS_OVERLAY_REQUIRED_KEY, false);
        this.filetype = settings.getString(FILETYPE_KEY, FILETYPE_DEFAULT_VALUE);
        this.filetypeEnabled = settings.getBoolean(FILETYPE_ENABLED_KEY, false);
        this.detectOrientation = settings.getBoolean(DETECT_ORIENTATION_KEY, false);
        this.isCreateSearchablePdf = settings.getBoolean(IS_CREATE_SEARCHABLE_PDF_KEY, false);
        this.isSearchablePdfHideTextLayer = settings.getBoolean(IS_SEARCHABLE_PDF_HIDE_TEXT_LAYER_KEY, false);
        this.scale = settings.getBoolean(SCALE_KEY, false);
        this.isTable = settings.getBoolean(IS_TABLE_KEY, false);
        this.oCREngine = settings.getString(OCR_ENGINE_KEY, OCR_ENGINE_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.file == null || this.file.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile\u201d is required.");
        }
        if (this.oCREngine == null || this.oCREngine.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOCR Engine\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String file() {
        return this.file;
    }

    void file(String value) {
        this.file = value;
    }

    String language() {
        return this.language;
    }

    void language(String value) {
        this.language = value;
    }

    boolean languageEnabled() {
        return this.languageEnabled;
    }

    void languageEnabled(boolean value) {
        this.languageEnabled = value;
    }

    boolean isOverlayRequired() {
        return this.isOverlayRequired;
    }

    void isOverlayRequired(boolean value) {
        this.isOverlayRequired = value;
    }

    String filetype() {
        return this.filetype;
    }

    void filetype(String value) {
        this.filetype = value;
    }

    boolean filetypeEnabled() {
        return this.filetypeEnabled;
    }

    void filetypeEnabled(boolean value) {
        this.filetypeEnabled = value;
    }

    boolean detectOrientation() {
        return this.detectOrientation;
    }

    void detectOrientation(boolean value) {
        this.detectOrientation = value;
    }

    boolean isCreateSearchablePdf() {
        return this.isCreateSearchablePdf;
    }

    void isCreateSearchablePdf(boolean value) {
        this.isCreateSearchablePdf = value;
    }

    boolean isSearchablePdfHideTextLayer() {
        return this.isSearchablePdfHideTextLayer;
    }

    void isSearchablePdfHideTextLayer(boolean value) {
        this.isSearchablePdfHideTextLayer = value;
    }

    boolean scale() {
        return this.scale;
    }

    void scale(boolean value) {
        this.scale = value;
    }

    boolean isTable() {
        return this.isTable;
    }

    void isTable(boolean value) {
        this.isTable = value;
    }

    String oCREngine() {
        return this.oCREngine;
    }

    void oCREngine(String value) {
        this.oCREngine = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

