/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.ocrspace.v1.operation.ocrforremotefile;

import com.nodepit.nodes.ocrspace.v1.LabelButton;
import com.nodepit.nodes.ocrspace.v1.ResponseMapper;
import com.nodepit.nodes.ocrspace.v1.operation.ocrforremotefile.OCRForRemoteFileNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class OCRForRemoteFileNodeDialog
extends NodeDialogPane {
    private final OCRForRemoteFileNodeSettings nodeSettings = new OCRForRemoteFileNodeSettings();
    private JTextField url;
    private JComboBox<String> language;
    private JCheckBox languageEnabled;
    private JCheckBox isOverlayRequired;
    private JComboBox<ResponseMapper> resultFormat;

    OCRForRemoteFileNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("Url:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.url = new JTextField(30);
        panel.add((Component)this.url, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Language:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.languageEnabled = new JCheckBox();
        this.languageEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.languageEnabled.setSelected(!this.languageEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.languageEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.language = new JComboBox<String>(OCRForRemoteFileNodeSettings.LANGUAGE_VALUES);
        panel.add(this.language, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Is Overlay Required:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.isOverlayRequired = new JCheckBox("true");
        panel.add((Component)this.isOverlayRequired, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(OCRForRemoteFileNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.language.setEnabled(this.languageEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.url(this.url.getText());
        this.nodeSettings.language((String)this.language.getSelectedItem());
        this.nodeSettings.languageEnabled(this.languageEnabled.isSelected());
        this.nodeSettings.isOverlayRequired(this.isOverlayRequired.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.url.setText(this.nodeSettings.url());
        this.language.setSelectedItem(this.nodeSettings.language());
        this.languageEnabled.setSelected(this.nodeSettings.languageEnabled());
        this.isOverlayRequired.setSelected(this.nodeSettings.isOverlayRequired());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

