/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.cancelevalrun;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class CancelEvalRunNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Eval Id", description="The ID of the evaluation whose run you want to cancel.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String evalId = null;
    @Widget(title="Run Id", description="The ID of the run to cancel.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String runId = null;
    @Widget(title="Result Format", description="\t<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n\t<p><b>Structured Table:</b> Returns a parsed table with data split into rows\n\tand columns.</p>\n\t<ul>\n\t\t<li><b>Object:</b> The type of the object. Always &quot;eval.run&quot;.</li>\n\t\t<li><b>Id:</b> Unique identifier for the evaluation run.</li>\n\t\t<li><b>Eval Id:</b> The identifier of the associated evaluation.</li>\n\t\t<li><b>Status:</b> The status of the evaluation run.</li>\n\t\t<li><b>Model:</b> The model that is evaluated, if applicable.</li>\n\t\t<li><b>Name:</b> The name of the evaluation run.</li>\n\t\t<li><b>Created At:</b> Unix timestamp (in seconds) when the evaluation run was created.</li>\n\t\t<li><b>Report Url:</b> The URL to the rendered evaluation run report on the UI dashboard.</li>\n\t\t<li><b>Result Counts:</b> Counters summarizing the outcomes of the evaluation run.</li>\n\t\t<li><b>Per Model Usage:</b> Usage statistics for each model during the evaluation run.</li>\n\t\t<li><b>Per Testing Criteria Results:</b> Results per testing criteria applied during the evaluation run.</li>\n\t\t<li><b>Data Source:</b> Information about the run's data source.</li>\n\t\t<li><b>Metadata:</b> <p>Set of 16 key-value pairs that can be attached to an object. This can be\nuseful for storing additional information about the object in a structured\nformat, and querying for objects via API or the dashboard.</p>\n<p>Keys are strings with a maximum length of 64 characters. Values are strings\nwith a maximum length of 512 characters.</p></li>\n\t\t<li><b>Error:</b> An object representing an error response from the Eval API.</li>\n\t</ul>\n\t<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n\t<ul>\n\t\t<li><b>body:</b> Response body</li>\n\t\t<li><b>status:</b> HTTP status code</li>\n\t</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=CancelEvalRunNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"object\":\"rows[0][0]\",\"id\":\"rows[0][1]\",\"eval_id\":\"rows[0][2]\",\"status\":\"rows[0][3]\",\"model\":\"rows[0][4]\",\"name\":\"rows[0][5]\",\"created_at\":\"rows[0][6]\",\"report_url\":\"rows[0][7]\",\"result_counts\":\"rows[0][8]\",\"per_model_usage\":\"rows[0][9]\",\"per_testing_criteria_results\":\"rows[0][10]\",\"data_source\":\"rows[0][11]\",\"metadata\":\"rows[0][12]\",\"error\":\"rows[0][13]\"}}]").addBodyColumn(new DataColumnSpecCreator("Object", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Eval Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Model", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Report Url", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Result Counts", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Per Model Usage", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Per Testing Criteria Results", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Data Source", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Metadata", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Error", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    CancelEvalRunNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.evalId == null || this.evalId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cEval Id\u201d is required.");
        }
        if (this.runId == null || this.runId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cRun Id\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("eval_id", this.evalId));
        params.add(new HttpRequestNodeParameters.Param("run_id", this.runId));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class CancelEvalRunNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private CancelEvalRunNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

