/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.cancelresponse;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class CancelResponseNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Response Id", description="The ID of the response to cancel.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String responseId = null;
    @Widget(title="Result Format", description="\t<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n\t<p><b>Structured Table:</b> Returns a parsed table with data split into rows\n\tand columns.</p>\n\t<ul>\n\t\t<li><b>Metadata:</b> <p>Set of 16 key-value pairs that can be attached to an object. This can be\nuseful for storing additional information about the object in a structured\nformat, and querying for objects via API or the dashboard.</p>\n<p>Keys are strings with a maximum length of 64 characters. Values are strings\nwith a maximum length of 512 characters.</p></li>\n\t\t<li><b>Top Logprobs:</b> An integer between 0 and 20 specifying the number of most likely tokens to\nreturn at each token position, each with an associated log probability.</li>\n\t\t<li><b>Temperature:</b> What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.\nWe generally recommend altering this or <tt>top_p</tt> but not both.</li>\n\t\t<li><b>Top P:</b> <p>An alternative to sampling with temperature, called nucleus sampling,\nwhere the model considers the results of the tokens with top_p probability\nmass. So 0.1 means only the tokens comprising the top 10% probability mass\nare considered.</p>\n<p>We generally recommend altering this or <tt>temperature</tt> but not both.</p></li>\n\t\t<li><b>User:</b> This field is being replaced by <tt>safety_identifier</tt> and <tt>prompt_cache_key</tt>. Use <tt>prompt_cache_key</tt> instead to maintain caching optimizations.\nA stable identifier for your end-users.\nUsed to boost cache hit rates by better bucketing similar requests and  to help OpenAI detect and prevent abuse. <a href=\"https://platform.openai.com/docs/guides/safety-best-practices#safety-identifiers\">Learn more</a>.</li>\n\t\t<li><b>Safety Identifier:</b> A stable identifier used to help detect users of your application that may be violating OpenAI's usage policies.\nThe IDs should be a string that uniquely identifies each user. We recommend hashing their username or email address, in order to avoid sending us any identifying information. <a href=\"https://platform.openai.com/docs/guides/safety-best-practices#safety-identifiers\">Learn more</a>.</li>\n\t\t<li><b>Prompt Cache Key:</b> Used by OpenAI to cache responses for similar requests to optimize your cache hit rates. Replaces the <tt>user</tt> field. <a href=\"https://platform.openai.com/docs/guides/prompt-caching\">Learn more</a>.</li>\n\t\t<li><b>Service Tier:</b> <p>Specifies the processing type used for serving the request.</p>\n<ul>\n<li>If set to 'auto', then the request will be processed with the service tier configured in the Project settings. Unless otherwise configured, the Project will use 'default'.</li>\n<li>If set to 'default', then the request will be processed with the standard pricing and performance for the selected model.</li>\n<li>If set to '<a href=\"https://platform.openai.com/docs/guides/flex-processing\">flex</a>' or '<a href=\"https://openai.com/api-priority-processing/\">priority</a>', then the request will be processed with the corresponding service tier.</li>\n<li>When not set, the default behavior is 'auto'.</li>\n</ul>\n<p>When the <tt>service_tier</tt> parameter is set, the response body will include the <tt>service_tier</tt> value based on the processing mode actually used to serve the request. This response value may be different from the value set in the parameter.</p></li>\n\t\t<li><b>Previous Response Id:</b> The unique ID of the previous response to the model. Use this to\ncreate multi-turn conversations. Learn more about\n<a href=\"https://platform.openai.com/docs/guides/conversation-state\">conversation state</a>. Cannot be used in conjunction with <tt>conversation</tt>.</li>\n\t\t<li><b>Model:</b> </li>\n\t\t<li><b>Reasoning:</b> <p><b>gpt-5 and o-series models only</b></p>\n<p>Configuration options for\n<a href=\"https://platform.openai.com/docs/guides/reasoning\">reasoning models</a>.</p></li>\n\t\t<li><b>Background:</b> Whether to run the model response in the background.\n<a href=\"https://platform.openai.com/docs/guides/background\">Learn more</a>.</li>\n\t\t<li><b>Max Output Tokens:</b> An upper bound for the number of tokens that can be generated for a response, including visible output tokens and <a href=\"https://platform.openai.com/docs/guides/reasoning\">reasoning tokens</a>.</li>\n\t\t<li><b>Max Tool Calls:</b> The maximum number of total calls to built-in tools that can be processed in a response. This maximum number applies across all built-in tool calls, not per individual tool. Any further attempts to call a tool by the model will be ignored.</li>\n\t\t<li><b>Text:</b> <p>Configuration options for a text response from the model. Can be plain\ntext or structured JSON data. Learn more:</p>\n<ul>\n<li><a href=\"https://platform.openai.com/docs/guides/text\">Text inputs and outputs</a></li>\n<li><a href=\"https://platform.openai.com/docs/guides/structured-outputs\">Structured Outputs</a></li>\n</ul></li>\n\t\t<li><b>Tools:</b> <p>An array of tools the model may call while generating a response. You\ncan specify which tool to use by setting the <tt>tool_choice</tt> parameter.</p>\n<p>The two categories of tools you can provide the model are:</p>\n<ul>\n<li><b>Built-in tools</b>: Tools that are provided by OpenAI that extend the\nmodel's capabilities, like <a href=\"https://platform.openai.com/docs/guides/tools-web-search\">web search</a>\nor <a href=\"https://platform.openai.com/docs/guides/tools-file-search\">file search</a>. Learn more about\n<a href=\"https://platform.openai.com/docs/guides/tools\">built-in tools</a>.</li>\n<li><b>Function calls (custom tools)</b>: Functions that are defined by you,\nenabling the model to call your own code with strongly typed arguments\nand outputs. Learn more about\n<a href=\"https://platform.openai.com/docs/guides/function-calling\">function calling</a>. You can also use\ncustom tools to call your own code.</li>\n</ul></li>\n\t\t<li><b>Tool Choice:</b> How the model should select which tool (or tools) to use when generating\na response. See the <tt>tools</tt> parameter to see how to specify which tools\nthe model can call.</li>\n\t\t<li><b>Prompt:</b> Reference to a prompt template and its variables.\n<a href=\"https://platform.openai.com/docs/guides/text?api-mode=responses#reusable-prompts\">Learn more</a>.</li>\n\t\t<li><b>Truncation:</b> <p>The truncation strategy to use for the model response.</p>\n<ul>\n<li><tt>auto</tt>: If the context of this response and previous ones exceeds\nthe model's context window size, the model will truncate the\nresponse to fit the context window by dropping input items in the\nmiddle of the conversation.</li>\n<li><tt>disabled</tt> (default): If a model response will exceed the context window\nsize for a model, the request will fail with a 400 error.</li>\n</ul></li>\n\t\t<li><b>Id:</b> Unique identifier for this Response.</li>\n\t\t<li><b>Object:</b> The object type of this resource - always set to <tt>response</tt>.</li>\n\t\t<li><b>Status:</b> The status of the response generation. One of <tt>completed</tt>, <tt>failed</tt>,\n<tt>in_progress</tt>, <tt>cancelled</tt>, <tt>queued</tt>, or <tt>incomplete</tt>.</li>\n\t\t<li><b>Created At:</b> Unix timestamp (in seconds) of when this Response was created.</li>\n\t\t<li><b>Error:</b> An error object returned when the model fails to generate a Response.</li>\n\t\t<li><b>Incomplete Details:</b> Details about why the response is incomplete.</li>\n\t\t<li><b>Output:</b> <p>An array of content items generated by the model.</p>\n<ul>\n<li>The length and order of items in the <tt>output</tt> array is dependent\non the model's response.</li>\n<li>Rather than accessing the first item in the <tt>output</tt> array and\nassuming it's an <tt>assistant</tt> message with the content generated by\nthe model, you might consider using the <tt>output_text</tt> property where\nsupported in SDKs.</li>\n</ul></li>\n\t\t<li><b>Instructions:</b> <p>A system (or developer) message inserted into the model's context.</p>\n<p>When using along with <tt>previous_response_id</tt>, the instructions from a previous\nresponse will not be carried over to the next response. This makes it simple\nto swap out system (or developer) messages in new responses.</p></li>\n\t\t<li><b>Output Text:</b> SDK-only convenience property that contains the aggregated text output\nfrom all <tt>output_text</tt> items in the <tt>output</tt> array, if any are present.\nSupported in the Python and JavaScript SDKs.</li>\n\t\t<li><b>Usage:</b> Represents token usage details including input tokens, output tokens,\na breakdown of output tokens, and the total tokens used.</li>\n\t\t<li><b>Parallel Tool Calls:</b> Whether to allow the model to run tool calls in parallel.</li>\n\t\t<li><b>Conversation:</b> The conversation that this response belongs to. Input items and output items from this response are automatically added to this conversation.</li>\n\t</ul>\n\t<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n\t<ul>\n\t\t<li><b>body:</b> Response body</li>\n\t\t<li><b>status:</b> HTTP status code</li>\n\t</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=CancelResponseNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"metadata\":\"rows[0][0]\",\"top_logprobs\":\"rows[0][1]\",\"temperature\":\"rows[0][2]\",\"top_p\":\"rows[0][3]\",\"user\":\"rows[0][4]\",\"safety_identifier\":\"rows[0][5]\",\"prompt_cache_key\":\"rows[0][6]\",\"service_tier\":\"rows[0][7]\",\"previous_response_id\":\"rows[0][8]\",\"model\":\"rows[0][9]\",\"reasoning\":\"rows[0][10]\",\"background\":\"rows[0][11]\",\"max_output_tokens\":\"rows[0][12]\",\"max_tool_calls\":\"rows[0][13]\",\"text\":\"rows[0][14]\",\"tools\":\"rows[0][15]\",\"tool_choice\":\"rows[0][16]\",\"prompt\":\"rows[0][17]\",\"truncation\":\"rows[0][18]\",\"id\":\"rows[0][19]\",\"object\":\"rows[0][20]\",\"status\":\"rows[0][21]\",\"created_at\":\"rows[0][22]\",\"error\":\"rows[0][23]\",\"incomplete_details\":\"rows[0][24]\",\"output\":\"rows[0][25]\",\"instructions\":\"rows[0][26]\",\"output_text\":\"rows[0][27]\",\"usage\":\"rows[0][28]\",\"parallel_tool_calls\":\"rows[0][29]\",\"conversation\":\"rows[0][30]\"}}]").addBodyColumn(new DataColumnSpecCreator("Metadata", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Top Logprobs", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Temperature", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Top P", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("User", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Safety Identifier", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Prompt Cache Key", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Service Tier", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Previous Response Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Model", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Reasoning", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Background", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Max Output Tokens", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Max Tool Calls", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Text", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Tools", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Tool Choice", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Prompt", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Truncation", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Object", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created At", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Error", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Incomplete Details", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Output", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Instructions", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Output Text", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Usage", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Parallel Tool Calls", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Conversation", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    CancelResponseNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.responseId == null || this.responseId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResponse Id\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("response_id", this.responseId));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class CancelResponseNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private CancelResponseNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

