/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.createcontainerfile;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class CreateContainerFileNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Container Id", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String containerId = null;
    @Widget(title="Set File Id", description="Enable to set the optional field <b>File Id</b>")
    @ValueReference(value=FileIdEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fileIdEnabled = false;
    @Widget(title="File Id", description="Name of the file to create.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FileIdEnabledRef.class, type=Effect.EffectType.SHOW)
    String fileId = null;
    @Widget(title="Set File", description="Enable to set the optional field <b>File</b>")
    @ValueReference(value=FileEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fileEnabled = false;
    @Widget(title="File", description="The File object (not file name) to be uploaded.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FileEnabledRef.class, type=Effect.EffectType.SHOW)
    @LocalFileReaderWidget
    String file = "";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Id:</b> Unique identifier for the file.</li>\n\t<li><b>Object:</b> The type of this object (<tt>container.file</tt>).</li>\n\t<li><b>Container Id:</b> The container this file belongs to.</li>\n\t<li><b>Created At:</b> Unix timestamp (in seconds) when the file was created.</li>\n\t<li><b>Bytes:</b> Size of the file in bytes.</li>\n\t<li><b>Path:</b> Path of the file in the container.</li>\n\t<li><b>Source:</b> Source of the file (e.g., <tt>user</tt>, <tt>assistant</tt>).</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=CreateContainerFileNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"id\":\"rows[0][0]\",\"object\":\"rows[0][1]\",\"container_id\":\"rows[0][2]\",\"created_at\":\"rows[0][3]\",\"bytes\":\"rows[0][4]\",\"path\":\"rows[0][5]\",\"source\":\"rows[0][6]\"}}]").addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Object", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Container Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Bytes", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Path", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Source", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    CreateContainerFileNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.containerId == null || this.containerId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cContainer Id\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("container_id", this.containerId));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.MULTIPART;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getBodyParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.fileIdEnabled) {
            params.add(new HttpRequestNodeParameters.Param("file_id", String.valueOf(this.fileId)));
        }
        if (this.fileEnabled) {
            params.add(new HttpRequestNodeParameters.Param("file", new HttpRequestNodeParameters.File(this.file)));
        }
        return params;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class CreateContainerFileNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private CreateContainerFileNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class FileEnabledRef
    implements BooleanReference {
        private FileEnabledRef() {
        }
    }

    private static final class FileIdEnabledRef
    implements BooleanReference {
        private FileIdEnabledRef() {
        }
    }
}

