/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.createfinetuningjob;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import com.nodepit.nodes.openai.v1.Utils;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.text.TextAreaWidget;

class CreateFineTuningJobNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Body", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextAreaWidget(rows=15)
    String body = BODY_DEFAULT_VALUE;
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", CreateFineTuningJobNodeParameters.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    @Widget(title="Result Format", description="\t<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n\t<p><b>Structured Table:</b> Returns a parsed table with data split into rows\n\tand columns.</p>\n\t<ul>\n\t\t<li><b>Id:</b> The object identifier, which can be referenced in the API endpoints.</li>\n\t\t<li><b>Created At:</b> The Unix timestamp (in seconds) for when the fine-tuning job was created.</li>\n\t\t<li><b>Error:</b> For fine-tuning jobs that have <tt>failed</tt>, this will contain more information on the cause of the failure.</li>\n\t\t<li><b>Fine Tuned Model:</b> The name of the fine-tuned model that is being created. The value will be null if the fine-tuning job is still running.</li>\n\t\t<li><b>Finished At:</b> The Unix timestamp (in seconds) for when the fine-tuning job was finished. The value will be null if the fine-tuning job is still running.</li>\n\t\t<li><b>Hyperparameters:</b> The hyperparameters used for the fine-tuning job. This value will only be returned when running <tt>supervised</tt> jobs.</li>\n\t\t<li><b>Model:</b> The base model that is being fine-tuned.</li>\n\t\t<li><b>Object:</b> The object type, which is always &quot;fine_tuning.job&quot;.</li>\n\t\t<li><b>Organization Id:</b> The organization that owns the fine-tuning job.</li>\n\t\t<li><b>Result Files:</b> The compiled results file ID(s) for the fine-tuning job. You can retrieve the results with the <a href=\"https://platform.openai.com/docs/api-reference/files/retrieve-contents\">Files API</a>.</li>\n\t\t<li><b>Status:</b> The current status of the fine-tuning job, which can be either <tt>validating_files</tt>, <tt>queued</tt>, <tt>running</tt>, <tt>succeeded</tt>, <tt>failed</tt>, or <tt>cancelled</tt>.</li>\n\t\t<li><b>Trained Tokens:</b> The total number of billable tokens processed by this fine-tuning job. The value will be null if the fine-tuning job is still running.</li>\n\t\t<li><b>Training File:</b> The file ID used for training. You can retrieve the training data with the <a href=\"https://platform.openai.com/docs/api-reference/files/retrieve-contents\">Files API</a>.</li>\n\t\t<li><b>Validation File:</b> The file ID used for validation. You can retrieve the validation results with the <a href=\"https://platform.openai.com/docs/api-reference/files/retrieve-contents\">Files API</a>.</li>\n\t\t<li><b>Integrations:</b> A list of integrations to enable for this fine-tuning job.</li>\n\t\t<li><b>Seed:</b> The seed used for the fine-tuning job.</li>\n\t\t<li><b>Estimated Finish:</b> The Unix timestamp (in seconds) for when the fine-tuning job is estimated to finish. The value will be null if the fine-tuning job is not running.</li>\n\t\t<li><b>Method:</b> The method used for fine-tuning.</li>\n\t\t<li><b>Metadata:</b> <p>Set of 16 key-value pairs that can be attached to an object. This can be\nuseful for storing additional information about the object in a structured\nformat, and querying for objects via API or the dashboard.</p>\n<p>Keys are strings with a maximum length of 64 characters. Values are strings\nwith a maximum length of 512 characters.</p></li>\n\t</ul>\n\t<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n\t<ul>\n\t\t<li><b>body:</b> Response body</li>\n\t\t<li><b>status:</b> HTTP status code</li>\n\t</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=CreateFineTuningJobNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"id\":\"rows[0][0]\",\"created_at\":\"rows[0][1]\",\"error\":\"rows[0][2]\",\"fine_tuned_model\":\"rows[0][3]\",\"finished_at\":\"rows[0][4]\",\"hyperparameters\":\"rows[0][5]\",\"model\":\"rows[0][6]\",\"object\":\"rows[0][7]\",\"organization_id\":\"rows[0][8]\",\"result_files\":\"rows[0][9]\",\"status\":\"rows[0][10]\",\"trained_tokens\":\"rows[0][11]\",\"training_file\":\"rows[0][12]\",\"validation_file\":\"rows[0][13]\",\"integrations\":\"rows[0][14]\",\"seed\":\"rows[0][15]\",\"estimated_finish\":\"rows[0][16]\",\"method\":\"rows[0][17]\",\"metadata\":\"rows[0][18]\"}}]").addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Error", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Fine Tuned Model", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Finished At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Hyperparameters", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Model", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Object", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Organization Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Result Files", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Trained Tokens", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Training File", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Validation File", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Integrations", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Seed", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Estimated Finish", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Method", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Metadata", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    CreateFineTuningJobNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.body == null || this.body.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cBody\u201d is required.");
        }
        if (!Utils.validateJsonBySchema(this.body, BODY_JSON_SCHEMA_FILE, this.getClass())) {
            throw new InvalidSettingsException("\u201cBody\u201d does not conform to the JSON schema.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.JSON;
    }

    @Override
    public String getJsonBody() {
        return this.body;
    }

    private static final class CreateFineTuningJobNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private CreateFineTuningJobNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

