/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.createimageedit;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;
import org.knime.node.parameters.widget.number.NumberInputWidgetValidation;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class CreateImageEditNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Image", description="\t<p>The image(s) to edit. Must be a supported image file or an array of images.</p>\n<p>For <tt>gpt-image-1</tt>, each image should be a <tt>png</tt>, <tt>webp</tt>, or <tt>jpg</tt> file less\nthan 50MB. You can provide up to 16 images.</p>\n<p>For <tt>dall-e-2</tt>, you can only provide one image, and it should be a square\n<tt>png</tt> file less than 4MB.</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String image = null;
    @Widget(title="Prompt", description="A text description of the desired image(s). The maximum length is 1000 characters for <tt>dall-e-2</tt>, and 32000 characters for <tt>gpt-image-1</tt>.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String prompt = null;
    @Widget(title="Set Mask", description="Enable to set the optional field <b>Mask</b>")
    @ValueReference(value=MaskEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean maskEnabled = false;
    @Widget(title="Mask", description="An additional image whose fully transparent areas (e.g. where alpha is zero) indicate where <tt>image</tt> should be edited. If there are multiple images provided, the mask will be applied on the first image. Must be a valid PNG file, less than 4MB, and have the same dimensions as <tt>image</tt>.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=MaskEnabledRef.class, type=Effect.EffectType.SHOW)
    @LocalFileReaderWidget
    String mask = "";
    @Widget(title="Set Background", description="Enable to set the optional field <b>Background</b>")
    @ValueReference(value=BackgroundEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean backgroundEnabled = false;
    @Widget(title="Background", description="\t<p>Allows to set transparency for the background of the generated image(s).\nThis parameter is only supported for <tt>gpt-image-1</tt>. Must be one of\n<tt>transparent</tt>, <tt>opaque</tt> or <tt>auto</tt> (default value). When <tt>auto</tt> is used, the\nmodel will automatically determine the best background for the image.</p>\n<p>If <tt>transparent</tt>, the output format needs to support transparency, so it\nshould be set to either <tt>png</tt> (default value) or <tt>webp</tt>.</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=BackgroundEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=BackgroundChoicesProvider.class)
    String background = "auto";
    private static final String[] BACKGROUND_VALUES = new String[]{"transparent", "opaque", "auto"};
    @Widget(title="Set Model", description="Enable to set the optional field <b>Model</b>")
    @ValueReference(value=ModelEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean modelEnabled = false;
    @Widget(title="Model", description="The model to use for image generation. Only <tt>dall-e-2</tt> and <tt>gpt-image-1</tt> are supported. Defaults to <tt>dall-e-2</tt> unless a parameter specific to <tt>gpt-image-1</tt> is used.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ModelEnabledRef.class, type=Effect.EffectType.SHOW)
    String model = null;
    @Widget(title="Set N", description="Enable to set the optional field <b>N</b>")
    @ValueReference(value=NEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean nEnabled = false;
    @Widget(title="N", description="The number of images to generate. Must be between 1 and 10.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=NEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget(minValidation=NMinValidation.class, maxValidation=NMaxValidation.class)
    int n = 1;
    @Widget(title="Set Size", description="Enable to set the optional field <b>Size</b>")
    @ValueReference(value=SizeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean sizeEnabled = false;
    @Widget(title="Size", description="The size of the generated images. Must be one of <tt>1024x1024</tt>, <tt>1536x1024</tt> (landscape), <tt>1024x1536</tt> (portrait), or <tt>auto</tt> (default value) for <tt>gpt-image-1</tt>, and one of <tt>256x256</tt>, <tt>512x512</tt>, or <tt>1024x1024</tt> for <tt>dall-e-2</tt>.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=SizeEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=SizeChoicesProvider.class)
    String size = "1024x1024";
    private static final String[] SIZE_VALUES = new String[]{"256x256", "512x512", "1024x1024", "1536x1024", "1024x1536", "auto"};
    @Widget(title="Set Response Format", description="Enable to set the optional field <b>Response Format</b>")
    @ValueReference(value=ResponseFormatEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean responseFormatEnabled = false;
    @Widget(title="Response Format", description="The format in which the generated images are returned. Must be one of <tt>url</tt> or <tt>b64_json</tt>. URLs are only valid for 60 minutes after the image has been generated. This parameter is only supported for <tt>dall-e-2</tt>, as <tt>gpt-image-1</tt> will always return base64-encoded images.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ResponseFormatEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Response_FormatChoicesProvider.class)
    String responseFormat = "url";
    private static final String[] RESPONSE_FORMAT_VALUES = new String[]{"url", "b64_json"};
    @Widget(title="Set Output Format", description="Enable to set the optional field <b>Output Format</b>")
    @ValueReference(value=OutputFormatEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean outputFormatEnabled = false;
    @Widget(title="Output Format", description="\tThe format in which the generated images are returned. This parameter is\nonly supported for <tt>gpt-image-1</tt>. Must be one of <tt>png</tt>, <tt>jpeg</tt>, or <tt>webp</tt>.\nThe default value is <tt>png</tt>.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=OutputFormatEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Output_FormatChoicesProvider.class)
    String outputFormat = "png";
    private static final String[] OUTPUT_FORMAT_VALUES = new String[]{"png", "jpeg", "webp"};
    @Widget(title="Set Output Compression", description="Enable to set the optional field <b>Output Compression</b>")
    @ValueReference(value=OutputCompressionEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean outputCompressionEnabled = false;
    @Widget(title="Output Compression", description="\tThe compression level (0-100%) for the generated images. This parameter\nis only supported for <tt>gpt-image-1</tt> with the <tt>webp</tt> or <tt>jpeg</tt> output\nformats, and defaults to 100.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=OutputCompressionEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int outputCompression = 100;
    @Widget(title="Set User", description="Enable to set the optional field <b>User</b>")
    @ValueReference(value=UserEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean userEnabled = false;
    @Widget(title="User", description="A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. <a href=\"https://platform.openai.com/docs/guides/safety-best-practices#end-user-ids\">Learn more</a>.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=UserEnabledRef.class, type=Effect.EffectType.SHOW)
    String user = null;
    @Widget(title="Set Input Fidelity", description="Enable to set the optional field <b>Input Fidelity</b>")
    @ValueReference(value=InputFidelityEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean inputFidelityEnabled = false;
    @Widget(title="Input Fidelity", description="\tControl how much effort the model will exert to match the style and features,\nespecially facial features, of input images. This parameter is only supported\nfor <tt>gpt-image-1</tt>. Supports <tt>high</tt> and <tt>low</tt>. Defaults to <tt>low</tt>.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=InputFidelityEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Input_FidelityChoicesProvider.class)
    String inputFidelity = "low";
    private static final String[] INPUT_FIDELITY_VALUES = new String[]{"high", "low"};
    @Widget(title="Set Stream", description="Enable to set the optional field <b>Stream</b>")
    @ValueReference(value=StreamEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean streamEnabled = false;
    @Widget(title="Stream", description="\tEdit the image in streaming mode. Defaults to <tt>false</tt>. See the\n<a href=\"https://platform.openai.com/docs/guides/image-generation\">Image generation guide</a> for more information.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=StreamEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=StreamPersistor.class)
    String stream = "false";
    @Widget(title="Set Partial Images", description="Enable to set the optional field <b>Partial Images</b>")
    @ValueReference(value=PartialImagesEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean partialImagesEnabled = false;
    @Widget(title="Partial Images", description="\t<p>The number of partial images to generate. This parameter is used for\nstreaming responses that return partial images. Value must be between 0 and 3.\nWhen set to 0, the response will be a single image sent in one streaming event.</p>\n<p>Note that the final image may be sent before the full number of partial images\nare generated if the full image is generated more quickly.</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PartialImagesEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget(minValidation=Partial_ImagesMinValidation.class, maxValidation=Partial_ImagesMaxValidation.class)
    int partialImages = 0;
    @Widget(title="Set Quality", description="Enable to set the optional field <b>Quality</b>")
    @ValueReference(value=QualityEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean qualityEnabled = false;
    @Widget(title="Quality", description="The quality of the image that will be generated. <tt>high</tt>, <tt>medium</tt> and <tt>low</tt> are only supported for <tt>gpt-image-1</tt>. <tt>dall-e-2</tt> only supports <tt>standard</tt> quality. Defaults to <tt>auto</tt>.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=QualityEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=QualityChoicesProvider.class)
    String quality = "auto";
    private static final String[] QUALITY_VALUES = new String[]{"standard", "low", "medium", "high", "auto"};
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Created:</b> The Unix timestamp (in seconds) of when the image was created.</li>\n\t<li><b>Data:</b> The list of generated images.</li>\n\t<li><b>Background:</b> The background parameter used for the image generation. Either <tt>transparent</tt> or <tt>opaque</tt>.</li>\n\t<li><b>Output Format:</b> The output format of the image generation. Either <tt>png</tt>, <tt>webp</tt>, or <tt>jpeg</tt>.</li>\n\t<li><b>Size:</b> The size of the image generated. Either <tt>1024x1024</tt>, <tt>1024x1536</tt>, or <tt>1536x1024</tt>.</li>\n\t<li><b>Quality:</b> The quality of the image generated. Either <tt>low</tt>, <tt>medium</tt>, or <tt>high</tt>.</li>\n\t<li><b>Usage:</b> For <tt>gpt-image-1</tt> only, the token usage information for the image generation.</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=CreateImageEditNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"created\":\"rows[0][0]\",\"data\":\"rows[0][1]\",\"background\":\"rows[0][2]\",\"output_format\":\"rows[0][3]\",\"size\":\"rows[0][4]\",\"quality\":\"rows[0][5]\",\"usage\":\"rows[0][6]\"}}]").addBodyColumn(new DataColumnSpecCreator("Created", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Data", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Background", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Output Format", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Size", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Quality", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Usage", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    CreateImageEditNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.prompt == null || this.prompt.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cPrompt\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.MULTIPART;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getBodyParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("image", String.valueOf(this.image)));
        params.add(new HttpRequestNodeParameters.Param("prompt", String.valueOf(this.prompt)));
        if (this.maskEnabled) {
            params.add(new HttpRequestNodeParameters.Param("mask", new HttpRequestNodeParameters.File(this.mask)));
        }
        if (this.backgroundEnabled) {
            params.add(new HttpRequestNodeParameters.Param("background", String.valueOf(this.background)));
        }
        if (this.modelEnabled) {
            params.add(new HttpRequestNodeParameters.Param("model", String.valueOf(this.model)));
        }
        if (this.nEnabled) {
            params.add(new HttpRequestNodeParameters.Param("n", String.valueOf(this.n)));
        }
        if (this.sizeEnabled) {
            params.add(new HttpRequestNodeParameters.Param("size", String.valueOf(this.size)));
        }
        if (this.responseFormatEnabled) {
            params.add(new HttpRequestNodeParameters.Param("response_format", String.valueOf(this.responseFormat)));
        }
        if (this.outputFormatEnabled) {
            params.add(new HttpRequestNodeParameters.Param("output_format", String.valueOf(this.outputFormat)));
        }
        if (this.outputCompressionEnabled) {
            params.add(new HttpRequestNodeParameters.Param("output_compression", String.valueOf(this.outputCompression)));
        }
        if (this.userEnabled) {
            params.add(new HttpRequestNodeParameters.Param("user", String.valueOf(this.user)));
        }
        if (this.inputFidelityEnabled) {
            params.add(new HttpRequestNodeParameters.Param("input_fidelity", String.valueOf(this.inputFidelity)));
        }
        if (this.streamEnabled) {
            params.add(new HttpRequestNodeParameters.Param("stream", String.valueOf(this.stream)));
        }
        if (this.partialImagesEnabled) {
            params.add(new HttpRequestNodeParameters.Param("partial_images", String.valueOf(this.partialImages)));
        }
        if (this.qualityEnabled) {
            params.add(new HttpRequestNodeParameters.Param("quality", String.valueOf(this.quality)));
        }
        return params;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class BackgroundChoicesProvider
    implements StringChoicesProvider {
        private BackgroundChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(BACKGROUND_VALUES);
        }
    }

    private static final class BackgroundEnabledRef
    implements BooleanReference {
        private BackgroundEnabledRef() {
        }
    }

    private static final class CreateImageEditNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private CreateImageEditNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class InputFidelityEnabledRef
    implements BooleanReference {
        private InputFidelityEnabledRef() {
        }
    }

    private static final class Input_FidelityChoicesProvider
    implements StringChoicesProvider {
        private Input_FidelityChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(INPUT_FIDELITY_VALUES);
        }
    }

    private static final class MaskEnabledRef
    implements BooleanReference {
        private MaskEnabledRef() {
        }
    }

    private static final class ModelEnabledRef
    implements BooleanReference {
        private ModelEnabledRef() {
        }
    }

    private static final class NEnabledRef
    implements BooleanReference {
        private NEnabledRef() {
        }
    }

    private static final class NMaxValidation
    extends NumberInputWidgetValidation.MaxValidation {
        private NMaxValidation() {
        }

        public double getMax() {
            return 10.0;
        }
    }

    private static final class NMinValidation
    extends NumberInputWidgetValidation.MinValidation {
        private NMinValidation() {
        }

        public double getMin() {
            return 1.0;
        }
    }

    private static final class OutputCompressionEnabledRef
    implements BooleanReference {
        private OutputCompressionEnabledRef() {
        }
    }

    private static final class OutputFormatEnabledRef
    implements BooleanReference {
        private OutputFormatEnabledRef() {
        }
    }

    private static final class Output_FormatChoicesProvider
    implements StringChoicesProvider {
        private Output_FormatChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(OUTPUT_FORMAT_VALUES);
        }
    }

    private static final class PartialImagesEnabledRef
    implements BooleanReference {
        private PartialImagesEnabledRef() {
        }
    }

    private static final class Partial_ImagesMaxValidation
    extends NumberInputWidgetValidation.MaxValidation {
        private Partial_ImagesMaxValidation() {
        }

        public double getMax() {
            return 3.0;
        }
    }

    private static final class Partial_ImagesMinValidation
    extends NumberInputWidgetValidation.MinValidation {
        private Partial_ImagesMinValidation() {
        }

        public double getMin() {
            return 0.0;
        }
    }

    private static final class QualityChoicesProvider
    implements StringChoicesProvider {
        private QualityChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(QUALITY_VALUES);
        }
    }

    private static final class QualityEnabledRef
    implements BooleanReference {
        private QualityEnabledRef() {
        }
    }

    private static final class ResponseFormatEnabledRef
    implements BooleanReference {
        private ResponseFormatEnabledRef() {
        }
    }

    private static final class Response_FormatChoicesProvider
    implements StringChoicesProvider {
        private Response_FormatChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(RESPONSE_FORMAT_VALUES);
        }
    }

    private static final class SizeChoicesProvider
    implements StringChoicesProvider {
        private SizeChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(SIZE_VALUES);
        }
    }

    private static final class SizeEnabledRef
    implements BooleanReference {
        private SizeEnabledRef() {
        }
    }

    private static final class StreamEnabledRef
    implements BooleanReference {
        private StreamEnabledRef() {
        }
    }

    private static final class StreamPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "stream";

        private StreamPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class UserEnabledRef
    implements BooleanReference {
        private UserEnabledRef() {
        }
    }
}

