/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.createrun;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import com.nodepit.nodes.openai.v1.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.text.TextAreaWidget;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class CreateRunNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="OpenAI Beta", description="Calls to the Assistants API require that you pass a beta HTTP header.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Open_AI_BetaChoicesProvider.class)
    String openAIBeta = OPEN_AI_BETA_VALUES[0];
    private static final String[] OPEN_AI_BETA_VALUES = new String[]{"assistants=v2"};
    @Widget(title="Thread Id", description="The ID of the thread to run.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String threadId = null;
    @Widget(title="Set Include[]", description="Enable to set the optional field <b>Include[]</b>")
    @ValueReference(value=IncludeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean includeEnabled = false;
    @Widget(title="Include[]", description="\t<p>A list of additional fields to include in the response. Currently the only supported value is <tt>step_details.tool_calls[*].file_search.results[*].content</tt> to fetch the file search result content.</p>\n<p>See the <a href=\"https://platform.openai.com/docs/assistants/tools/file-search#customizing-file-search-settings\">file search tool documentation</a> for more information.</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=IncludeEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=IncludePersistor.class)
    Include[] include = new Include[]{new Include(INCLUDE_VALUES[0])};
    private static final String[] INCLUDE_VALUES = new String[]{"step_details.tool_calls[*].file_search.results[*].content"};
    @Widget(title="Body", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextAreaWidget(rows=15)
    String body = BODY_DEFAULT_VALUE;
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", CreateRunNodeParameters.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    @Widget(title="Result Format", description="\t<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n\t<p><b>Structured Table:</b> Returns a parsed table with data split into rows\n\tand columns.</p>\n\t<ul>\n\t\t<li><b>Id:</b> The identifier, which can be referenced in API endpoints.</li>\n\t\t<li><b>Object:</b> The object type, which is always <tt>thread.run</tt>.</li>\n\t\t<li><b>Created At:</b> The Unix timestamp (in seconds) for when the run was created.</li>\n\t\t<li><b>Thread Id:</b> The ID of the <a href=\"https://platform.openai.com/docs/api-reference/threads\">thread</a> that was executed on as a part of this run.</li>\n\t\t<li><b>Assistant Id:</b> The ID of the <a href=\"https://platform.openai.com/docs/api-reference/assistants\">assistant</a> used for execution of this run.</li>\n\t\t<li><b>Status:</b> The status of the run, which can be either <tt>queued</tt>, <tt>in_progress</tt>, <tt>requires_action</tt>, <tt>cancelling</tt>, <tt>cancelled</tt>, <tt>failed</tt>, <tt>completed</tt>, <tt>incomplete</tt>, or <tt>expired</tt>.</li>\n\t\t<li><b>Required Action:</b> Details on the action required to continue the run. Will be <tt>null</tt> if no action is required.</li>\n\t\t<li><b>Last Error:</b> The last error associated with this run. Will be <tt>null</tt> if there are no errors.</li>\n\t\t<li><b>Expires At:</b> The Unix timestamp (in seconds) for when the run will expire.</li>\n\t\t<li><b>Started At:</b> The Unix timestamp (in seconds) for when the run was started.</li>\n\t\t<li><b>Cancelled At:</b> The Unix timestamp (in seconds) for when the run was cancelled.</li>\n\t\t<li><b>Failed At:</b> The Unix timestamp (in seconds) for when the run failed.</li>\n\t\t<li><b>Completed At:</b> The Unix timestamp (in seconds) for when the run was completed.</li>\n\t\t<li><b>Incomplete Details:</b> Details on why the run is incomplete. Will be <tt>null</tt> if the run is not incomplete.</li>\n\t\t<li><b>Model:</b> The model that the <a href=\"https://platform.openai.com/docs/api-reference/assistants\">assistant</a> used for this run.</li>\n\t\t<li><b>Instructions:</b> The instructions that the <a href=\"https://platform.openai.com/docs/api-reference/assistants\">assistant</a> used for this run.</li>\n\t\t<li><b>Tools:</b> The list of tools that the <a href=\"https://platform.openai.com/docs/api-reference/assistants\">assistant</a> used for this run.</li>\n\t\t<li><b>Metadata:</b> <p>Set of 16 key-value pairs that can be attached to an object. This can be\nuseful for storing additional information about the object in a structured\nformat, and querying for objects via API or the dashboard.</p>\n<p>Keys are strings with a maximum length of 64 characters. Values are strings\nwith a maximum length of 512 characters.</p></li>\n\t\t<li><b>Usage:</b> Usage statistics related to the run. This value will be <tt>null</tt> if the run is not in a terminal state (i.e. <tt>in_progress</tt>, <tt>queued</tt>, etc.).</li>\n\t\t<li><b>Temperature:</b> The sampling temperature used for this run. If not set, defaults to 1.</li>\n\t\t<li><b>Top P:</b> The nucleus sampling value used for this run. If not set, defaults to 1.</li>\n\t\t<li><b>Max Prompt Tokens:</b> The maximum number of prompt tokens specified to have been used over the course of the run.</li>\n\t\t<li><b>Max Completion Tokens:</b> The maximum number of completion tokens specified to have been used over the course of the run.</li>\n\t\t<li><b>Truncation Strategy:</b> Controls for how a thread will be truncated prior to the run. Use this to control the initial context window of the run.</li>\n\t\t<li><b>Tool Choice:</b> Controls which (if any) tool is called by the model.\n<tt>none</tt> means the model will not call any tools and instead generates a message.\n<tt>auto</tt> is the default value and means the model can pick between generating a message or calling one or more tools.\n<tt>required</tt> means the model must call one or more tools before responding to the user.\nSpecifying a particular tool like <tt>{&quot;type&quot;: &quot;file_search&quot;}</tt> or <tt>{&quot;type&quot;: &quot;function&quot;, &quot;function&quot;: {&quot;name&quot;: &quot;my_function&quot;}}</tt> forces the model to call that tool.</li>\n\t\t<li><b>Parallel Tool Calls:</b> Whether to enable <a href=\"https://platform.openai.com/docs/guides/function-calling#configuring-parallel-function-calling\">parallel function calling</a> during tool use.</li>\n\t\t<li><b>Response Format:</b> <p>Specifies the format that the model must output. Compatible with <a href=\"https://platform.openai.com/docs/models#gpt-4o\">GPT-4o</a>, <a href=\"https://platform.openai.com/docs/models#gpt-4-turbo-and-gpt-4\">GPT-4 Turbo</a>, and all GPT-3.5 Turbo models since <tt>gpt-3.5-turbo-1106</tt>.</p>\n<p>Setting to <tt>{ &quot;type&quot;: &quot;json_schema&quot;, &quot;json_schema&quot;: {...} }</tt> enables Structured Outputs which ensures the model will match your supplied JSON schema. Learn more in the <a href=\"https://platform.openai.com/docs/guides/structured-outputs\">Structured Outputs guide</a>.</p>\n<p>Setting to <tt>{ &quot;type&quot;: &quot;json_object&quot; }</tt> enables JSON mode, which ensures the message the model generates is valid JSON.</p>\n<p><b>Important:</b> when using JSON mode, you <b>must</b> also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly &quot;stuck&quot; request. Also note that the message content may be partially cut off if <tt>finish_reason=&quot;length&quot;</tt>, which indicates the generation exceeded <tt>max_tokens</tt> or the conversation exceeded the max context length.</p></li>\n\t</ul>\n\t<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n\t<ul>\n\t\t<li><b>body:</b> Response body</li>\n\t\t<li><b>status:</b> HTTP status code</li>\n\t</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=CreateRunNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"id\":\"rows[0][0]\",\"object\":\"rows[0][1]\",\"created_at\":\"rows[0][2]\",\"thread_id\":\"rows[0][3]\",\"assistant_id\":\"rows[0][4]\",\"status\":\"rows[0][5]\",\"required_action\":\"rows[0][6]\",\"last_error\":\"rows[0][7]\",\"expires_at\":\"rows[0][8]\",\"started_at\":\"rows[0][9]\",\"cancelled_at\":\"rows[0][10]\",\"failed_at\":\"rows[0][11]\",\"completed_at\":\"rows[0][12]\",\"incomplete_details\":\"rows[0][13]\",\"model\":\"rows[0][14]\",\"instructions\":\"rows[0][15]\",\"tools\":\"rows[0][16]\",\"metadata\":\"rows[0][17]\",\"usage\":\"rows[0][18]\",\"temperature\":\"rows[0][19]\",\"top_p\":\"rows[0][20]\",\"max_prompt_tokens\":\"rows[0][21]\",\"max_completion_tokens\":\"rows[0][22]\",\"truncation_strategy\":\"rows[0][23]\",\"tool_choice\":\"rows[0][24]\",\"parallel_tool_calls\":\"rows[0][25]\",\"response_format\":\"rows[0][26]\"}}]").addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Object", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Thread Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Assistant Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Required Action", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Last Error", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Expires At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Started At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Cancelled At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Failed At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Completed At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Incomplete Details", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Model", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Instructions", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Tools", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Metadata", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Usage", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Temperature", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Top P", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Max Prompt Tokens", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Max Completion Tokens", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Truncation Strategy", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Tool Choice", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Parallel Tool Calls", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Response Format", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    CreateRunNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.openAIBeta == null || this.openAIBeta.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOpenAI Beta\u201d is required.");
        }
        if (this.threadId == null || this.threadId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cThread Id\u201d is required.");
        }
        if (this.body == null || this.body.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cBody\u201d is required.");
        }
        if (!Utils.validateJsonBySchema(this.body, BODY_JSON_SCHEMA_FILE, this.getClass())) {
            throw new InvalidSettingsException("\u201cBody\u201d does not conform to the JSON schema.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("thread_id", this.threadId));
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.includeEnabled) {
            Arrays.stream(this.include).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("include[]", value.text));
            });
        }
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getHeaderParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("OpenAI-Beta", this.openAIBeta));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.JSON;
    }

    @Override
    public String getJsonBody() {
        return this.body;
    }

    private static final class CreateRunNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private CreateRunNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    static final class Include
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=IncludeChoicesProvider.class)
        String text;

        Include() {
        }

        Include(String text) {
            this.text = text;
        }

        private static final class IncludeChoicesProvider
        implements StringChoicesProvider {
            private IncludeChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(INCLUDE_VALUES);
            }
        }
    }

    private static final class IncludeEnabledRef
    implements BooleanReference {
        private IncludeEnabledRef() {
        }
    }

    private static final class IncludePersistor
    implements NodeParametersPersistor<Include[]> {
        static final String CONFIG_KEY = "include";

        private IncludePersistor() {
        }

        public Include[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Include[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Include::new).toArray(Include[]::new);
        }

        public void save(Include[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class Open_AI_BetaChoicesProvider
    implements StringChoicesProvider {
        private Open_AI_BetaChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(OPEN_AI_BETA_VALUES);
        }
    }
}

