/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.createtranslation;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class CreateTranslationNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File", description="The audio file object (not file name) translate, in one of these formats: flac, mp3, mp4, mpeg, mpga, m4a, ogg, wav, or webm.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String file = "";
    @Widget(title="Model", description="ID of the model to use. Only <tt>whisper-1</tt> (which is powered by our open source Whisper V2 model) is currently available.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String model = null;
    @Widget(title="Set Prompt", description="Enable to set the optional field <b>Prompt</b>")
    @ValueReference(value=PromptEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean promptEnabled = false;
    @Widget(title="Prompt", description="An optional text to guide the model's style or continue a previous audio segment. The <a href=\"https://platform.openai.com/docs/guides/speech-to-text#prompting\">prompt</a> should be in English.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PromptEnabledRef.class, type=Effect.EffectType.SHOW)
    String prompt = null;
    @Widget(title="Set Response Format", description="Enable to set the optional field <b>Response Format</b>")
    @ValueReference(value=ResponseFormatEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean responseFormatEnabled = false;
    @Widget(title="Response Format", description="The format of the output, in one of these options: <tt>json</tt>, <tt>text</tt>, <tt>srt</tt>, <tt>verbose_json</tt>, or <tt>vtt</tt>.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ResponseFormatEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Response_FormatChoicesProvider.class)
    String responseFormat = "json";
    private static final String[] RESPONSE_FORMAT_VALUES = new String[]{"json", "text", "srt", "verbose_json", "vtt"};
    @Widget(title="Set Temperature", description="Enable to set the optional field <b>Temperature</b>")
    @ValueReference(value=TemperatureEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean temperatureEnabled = false;
    @Widget(title="Temperature", description="The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. If set to 0, the model will use <a href=\"https://en.wikipedia.org/wiki/Log_probability\">log probability</a> to automatically increase the temperature until certain thresholds are hit.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=TemperatureEnabledRef.class, type=Effect.EffectType.SHOW)
    String temperature = null;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Text:</b> The translated text.</li>\n\t<li><b>Language:</b> The language of the output translation (always <tt>english</tt>).</li>\n\t<li><b>Duration:</b> The duration of the input audio.</li>\n\t<li><b>Segments:</b> Segments of the translated text and their corresponding details.</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=CreateTranslationNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"text\":\"rows[0][0]\",\"language\":\"rows[0][1]\",\"duration\":\"rows[0][2]\",\"segments\":\"rows[0][3]\"}}]").addBodyColumn(new DataColumnSpecCreator("Text", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Language", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Duration", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Segments", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    CreateTranslationNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.file == null || this.file.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.MULTIPART;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getBodyParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("file", new HttpRequestNodeParameters.File(this.file)));
        params.add(new HttpRequestNodeParameters.Param("model", String.valueOf(this.model)));
        if (this.promptEnabled) {
            params.add(new HttpRequestNodeParameters.Param("prompt", String.valueOf(this.prompt)));
        }
        if (this.responseFormatEnabled) {
            params.add(new HttpRequestNodeParameters.Param("response_format", String.valueOf(this.responseFormat)));
        }
        if (this.temperatureEnabled) {
            params.add(new HttpRequestNodeParameters.Param("temperature", String.valueOf(this.temperature)));
        }
        return params;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class CreateTranslationNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private CreateTranslationNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class PromptEnabledRef
    implements BooleanReference {
        private PromptEnabledRef() {
        }
    }

    private static final class ResponseFormatEnabledRef
    implements BooleanReference {
        private ResponseFormatEnabledRef() {
        }
    }

    private static final class Response_FormatChoicesProvider
    implements StringChoicesProvider {
        private Response_FormatChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(RESPONSE_FORMAT_VALUES);
        }
    }

    private static final class TemperatureEnabledRef
    implements BooleanReference {
        private TemperatureEnabledRef() {
        }
    }
}

