/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.createvectorstorefile;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import com.nodepit.nodes.openai.v1.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.text.TextAreaWidget;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class CreateVectorStoreFileNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="OpenAI Beta", description="Calls to the Assistants API require that you pass a beta HTTP header.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Open_AI_BetaChoicesProvider.class)
    String openAIBeta = OPEN_AI_BETA_VALUES[0];
    private static final String[] OPEN_AI_BETA_VALUES = new String[]{"assistants=v2"};
    @Widget(title="Vector Store Id", description="The ID of the vector store for which to create a File.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String vectorStoreId = null;
    @Widget(title="Body", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextAreaWidget(rows=15)
    String body = BODY_DEFAULT_VALUE;
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", CreateVectorStoreFileNodeParameters.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    @Widget(title="Result Format", description="\t<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n\t<p><b>Structured Table:</b> Returns a parsed table with data split into rows\n\tand columns.</p>\n\t<ul>\n\t\t<li><b>Id:</b> The identifier, which can be referenced in API endpoints.</li>\n\t\t<li><b>Object:</b> The object type, which is always <tt>vector_store.file</tt>.</li>\n\t\t<li><b>Usage Bytes:</b> The total vector store usage in bytes. Note that this may be different from the original file size.</li>\n\t\t<li><b>Created At:</b> The Unix timestamp (in seconds) for when the vector store file was created.</li>\n\t\t<li><b>Vector Store Id:</b> The ID of the <a href=\"https://platform.openai.com/docs/api-reference/vector-stores/object\">vector store</a> that the <a href=\"https://platform.openai.com/docs/api-reference/files\">File</a> is attached to.</li>\n\t\t<li><b>Status:</b> The status of the vector store file, which can be either <tt>in_progress</tt>, <tt>completed</tt>, <tt>cancelled</tt>, or <tt>failed</tt>. The status <tt>completed</tt> indicates that the vector store file is ready for use.</li>\n\t\t<li><b>Last Error:</b> The last error associated with this vector store file. Will be <tt>null</tt> if there are no errors.</li>\n\t\t<li><b>Chunking Strategy:</b> The strategy used to chunk the file.</li>\n\t\t<li><b>Attributes:</b> Set of 16 key-value pairs that can be attached to an object. This can be\nuseful for storing additional information about the object in a structured\nformat, and querying for objects via API or the dashboard. Keys are strings\nwith a maximum length of 64 characters. Values are strings with a maximum\nlength of 512 characters, booleans, or numbers.</li>\n\t</ul>\n\t<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n\t<ul>\n\t\t<li><b>body:</b> Response body</li>\n\t\t<li><b>status:</b> HTTP status code</li>\n\t</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=CreateVectorStoreFileNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"id\":\"rows[0][0]\",\"object\":\"rows[0][1]\",\"usage_bytes\":\"rows[0][2]\",\"created_at\":\"rows[0][3]\",\"vector_store_id\":\"rows[0][4]\",\"status\":\"rows[0][5]\",\"last_error\":\"rows[0][6]\",\"chunking_strategy\":\"rows[0][7]\",\"attributes\":\"rows[0][8]\"}}]").addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Object", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Usage Bytes", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Vector Store Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Last Error", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Chunking Strategy", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Attributes", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    CreateVectorStoreFileNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.openAIBeta == null || this.openAIBeta.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOpenAI Beta\u201d is required.");
        }
        if (this.vectorStoreId == null || this.vectorStoreId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cVector Store Id\u201d is required.");
        }
        if (this.body == null || this.body.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cBody\u201d is required.");
        }
        if (!Utils.validateJsonBySchema(this.body, BODY_JSON_SCHEMA_FILE, this.getClass())) {
            throw new InvalidSettingsException("\u201cBody\u201d does not conform to the JSON schema.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("vector_store_id", this.vectorStoreId));
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getHeaderParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("OpenAI-Beta", this.openAIBeta));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.JSON;
    }

    @Override
    public String getJsonBody() {
        return this.body;
    }

    private static final class CreateVectorStoreFileNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private CreateVectorStoreFileNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class Open_AI_BetaChoicesProvider
    implements StringChoicesProvider {
        private Open_AI_BetaChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(OPEN_AI_BETA_VALUES);
        }
    }
}

