/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.getevalrunoutputitem;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetEvalRunOutputItemNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Eval Id", description="The ID of the evaluation to retrieve runs for.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String evalId = null;
    @Widget(title="Run Id", description="The ID of the run to retrieve.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String runId = null;
    @Widget(title="Output Item Id", description="The ID of the output item to retrieve.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String outputItemId = null;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Object:</b> The type of the object. Always &quot;eval.run.output_item&quot;.</li>\n\t<li><b>Id:</b> Unique identifier for the evaluation run output item.</li>\n\t<li><b>Run Id:</b> The identifier of the evaluation run associated with this output item.</li>\n\t<li><b>Eval Id:</b> The identifier of the evaluation group.</li>\n\t<li><b>Created At:</b> Unix timestamp (in seconds) when the evaluation run was created.</li>\n\t<li><b>Status:</b> The status of the evaluation run.</li>\n\t<li><b>Datasource Item Id:</b> The identifier for the data source item.</li>\n\t<li><b>Datasource Item:</b> Details of the input data source item.</li>\n\t<li><b>Results:</b> A list of results from the evaluation run.</li>\n\t<li><b>Sample:</b> A sample containing the input and output of the evaluation run.</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetEvalRunOutputItemNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"object\":\"rows[0][0]\",\"id\":\"rows[0][1]\",\"run_id\":\"rows[0][2]\",\"eval_id\":\"rows[0][3]\",\"created_at\":\"rows[0][4]\",\"status\":\"rows[0][5]\",\"datasource_item_id\":\"rows[0][6]\",\"datasource_item\":\"rows[0][7]\",\"results\":\"rows[0][8]\",\"sample\":\"rows[0][9]\"}}]").addBodyColumn(new DataColumnSpecCreator("Object", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Run Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Eval Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Datasource Item Id", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Datasource Item", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Results", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Sample", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetEvalRunOutputItemNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.evalId == null || this.evalId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cEval Id\u201d is required.");
        }
        if (this.runId == null || this.runId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cRun Id\u201d is required.");
        }
        if (this.outputItemId == null || this.outputItemId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOutput Item Id\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("eval_id", this.evalId));
        params.add(new HttpRequestNodeParameters.Param("run_id", this.runId));
        params.add(new HttpRequestNodeParameters.Param("output_item_id", this.outputItemId));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class GetEvalRunOutputItemNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetEvalRunOutputItemNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

