/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.updateprojectratelimits;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import com.nodepit.nodes.openai.v1.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.text.TextAreaWidget;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class UpdateProjectRateLimitsNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Project Id", description="The ID of the project.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String projectId = null;
    @Widget(title="Rate Limit Id", description="The ID of the rate limit.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String rateLimitId = null;
    @Widget(title="Body", description="The project rate limit update request payload.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextAreaWidget(rows=15)
    String body = BODY_DEFAULT_VALUE;
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", UpdateProjectRateLimitsNodeParameters.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Object:</b> The object type, which is always <tt>project.rate_limit</tt></li>\n\t<li><b>Id:</b> The identifier, which can be referenced in API endpoints.</li>\n\t<li><b>Model:</b> The model this rate limit applies to.</li>\n\t<li><b>Max Requests Per 1 Minute:</b> The maximum requests per minute.</li>\n\t<li><b>Max Tokens Per 1 Minute:</b> The maximum tokens per minute.</li>\n\t<li><b>Max Images Per 1 Minute:</b> The maximum images per minute. Only present for relevant models.</li>\n\t<li><b>Max Audio Megabytes Per 1 Minute:</b> The maximum audio megabytes per minute. Only present for relevant models.</li>\n\t<li><b>Max Requests Per 1 Day:</b> The maximum requests per day. Only present for relevant models.</li>\n\t<li><b>Batch 1 Day Max Input Tokens:</b> The maximum batch input tokens per day. Only present for relevant models.</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=UpdateProjectRateLimitsNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"object\":\"rows[0][0]\",\"id\":\"rows[0][1]\",\"model\":\"rows[0][2]\",\"max_requests_per_1_minute\":\"rows[0][3]\",\"max_tokens_per_1_minute\":\"rows[0][4]\",\"max_images_per_1_minute\":\"rows[0][5]\",\"max_audio_megabytes_per_1_minute\":\"rows[0][6]\",\"max_requests_per_1_day\":\"rows[0][7]\",\"batch_1_day_max_input_tokens\":\"rows[0][8]\"}}]").addBodyColumn(new DataColumnSpecCreator("Object", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Model", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Max Requests Per 1 Minute", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Max Tokens Per 1 Minute", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Max Images Per 1 Minute", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Max Audio Megabytes Per 1 Minute", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Max Requests Per 1 Day", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Batch 1 Day Max Input Tokens", LongCell.LongCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    UpdateProjectRateLimitsNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.projectId == null || this.projectId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cProject Id\u201d is required.");
        }
        if (this.rateLimitId == null || this.rateLimitId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cRate Limit Id\u201d is required.");
        }
        if (this.body == null || this.body.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cBody\u201d is required.");
        }
        if (!Utils.validateJsonBySchema(this.body, BODY_JSON_SCHEMA_FILE, this.getClass())) {
            throw new InvalidSettingsException("\u201cBody\u201d does not conform to the JSON schema.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("project_id", this.projectId));
        params.add(new HttpRequestNodeParameters.Param("rate_limit_id", this.rateLimitId));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.JSON;
    }

    @Override
    public String getJsonBody() {
        return this.body;
    }

    private static final class UpdateProjectRateLimitsNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private UpdateProjectRateLimitsNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

