/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.usagemoderations;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;

class UsageModerationsNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Start Time", description="Start time (Unix seconds) of the query time range, inclusive.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @NumberInputWidget
    int startTime = 0;
    @Widget(title="Set End Time", description="Enable to set the optional field <b>End Time</b>")
    @ValueReference(value=EndTimeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean endTimeEnabled = false;
    @Widget(title="End Time", description="End time (Unix seconds) of the query time range, exclusive.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=EndTimeEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int endTime = 0;
    @Widget(title="Set Bucket Width", description="Enable to set the optional field <b>Bucket Width</b>")
    @ValueReference(value=BucketWidthEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean bucketWidthEnabled = false;
    @Widget(title="Bucket Width", description="Width of each time bucket in response. Currently <tt>1m</tt>, <tt>1h</tt> and <tt>1d</tt> are supported, default to <tt>1d</tt>.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=BucketWidthEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Bucket_WidthChoicesProvider.class)
    String bucketWidth = "1d";
    private static final String[] BUCKET_WIDTH_VALUES = new String[]{"1m", "1h", "1d"};
    @Widget(title="Set Project Ids", description="Enable to set the optional field <b>Project Ids</b>")
    @ValueReference(value=ProjectIdsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean projectIdsEnabled = false;
    @Widget(title="Project Ids", description="Return only usage for these projects.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ProjectIdsEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Project_IdsPersistor.class)
    Project_Ids[] projectIds = new Project_Ids[]{new Project_Ids(null)};
    @Widget(title="Set User Ids", description="Enable to set the optional field <b>User Ids</b>")
    @ValueReference(value=UserIdsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean userIdsEnabled = false;
    @Widget(title="User Ids", description="Return only usage for these users.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=UserIdsEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=User_IdsPersistor.class)
    User_Ids[] userIds = new User_Ids[]{new User_Ids(null)};
    @Widget(title="Set Api Key Ids", description="Enable to set the optional field <b>Api Key Ids</b>")
    @ValueReference(value=ApiKeyIdsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean apiKeyIdsEnabled = false;
    @Widget(title="Api Key Ids", description="Return only usage for these API keys.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ApiKeyIdsEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Api_Key_IdsPersistor.class)
    Api_Key_Ids[] apiKeyIds = new Api_Key_Ids[]{new Api_Key_Ids(null)};
    @Widget(title="Set Models", description="Enable to set the optional field <b>Models</b>")
    @ValueReference(value=ModelsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean modelsEnabled = false;
    @Widget(title="Models", description="Return only usage for these models.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ModelsEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=ModelsPersistor.class)
    Models[] models = new Models[]{new Models(null)};
    @Widget(title="Set Group By", description="Enable to set the optional field <b>Group By</b>")
    @ValueReference(value=GroupByEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean groupByEnabled = false;
    @Widget(title="Group By", description="Group the usage data by the specified fields. Support fields include <tt>project_id</tt>, <tt>user_id</tt>, <tt>api_key_id</tt>, <tt>model</tt> or any combination of them.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=GroupByEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Group_ByPersistor.class)
    Group_By[] groupBy = new Group_By[]{new Group_By(GROUP_BY_VALUES[0])};
    private static final String[] GROUP_BY_VALUES = new String[]{"project_id", "user_id", "api_key_id", "model"};
    @Widget(title="Set Limit", description="Enable to set the optional field <b>Limit</b>")
    @ValueReference(value=LimitEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean limitEnabled = false;
    @Widget(title="Limit", description="\t<p>Specifies the number of buckets to return.</p>\n<ul>\n<li><tt>bucket_width=1d</tt>: default: 7, max: 31</li>\n<li><tt>bucket_width=1h</tt>: default: 24, max: 168</li>\n<li><tt>bucket_width=1m</tt>: default: 60, max: 1440</li>\n</ul>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=LimitEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int limit = 0;
    @Widget(title="Set Page", description="Enable to set the optional field <b>Page</b>")
    @ValueReference(value=PageEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean pageEnabled = false;
    @Widget(title="Page", description="A cursor for use in pagination. Corresponding to the <tt>next_page</tt> field from the previous response.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PageEnabledRef.class, type=Effect.EffectType.SHOW)
    String page = null;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Object:</b> </li>\n\t<li><b>Data:</b> </li>\n\t<li><b>Has More:</b> </li>\n\t<li><b>Next Page:</b> </li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=UsageModerationsNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"object\":\"rows[0][0]\",\"data\":\"rows[0][1]\",\"has_more\":\"rows[0][2]\",\"next_page\":\"rows[0][3]\"}}]").addBodyColumn(new DataColumnSpecCreator("Object", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Data", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has More", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Next Page", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    UsageModerationsNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("start_time", this.startTime));
        if (this.endTimeEnabled) {
            params.add(new HttpRequestNodeParameters.Param("end_time", this.endTime));
        }
        if (this.bucketWidthEnabled) {
            params.add(new HttpRequestNodeParameters.Param("bucket_width", this.bucketWidth));
        }
        if (this.projectIdsEnabled) {
            Arrays.stream(this.projectIds).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("project_ids", value.text));
            });
        }
        if (this.userIdsEnabled) {
            Arrays.stream(this.userIds).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("user_ids", value.text));
            });
        }
        if (this.apiKeyIdsEnabled) {
            Arrays.stream(this.apiKeyIds).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("api_key_ids", value.text));
            });
        }
        if (this.modelsEnabled) {
            Arrays.stream(this.models).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("models", value.text));
            });
        }
        if (this.groupByEnabled) {
            Arrays.stream(this.groupBy).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("group_by", value.text));
            });
        }
        if (this.limitEnabled) {
            params.add(new HttpRequestNodeParameters.Param("limit", this.limit));
        }
        if (this.pageEnabled) {
            params.add(new HttpRequestNodeParameters.Param("page", this.page));
        }
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class ApiKeyIdsEnabledRef
    implements BooleanReference {
        private ApiKeyIdsEnabledRef() {
        }
    }

    static final class Api_Key_Ids
    implements WidgetGroup {
        @Widget(title="", description="")
        String text;

        Api_Key_Ids() {
        }

        Api_Key_Ids(String text) {
            this.text = text;
        }
    }

    private static final class Api_Key_IdsPersistor
    implements NodeParametersPersistor<Api_Key_Ids[]> {
        static final String CONFIG_KEY = "apiKeyIds";

        private Api_Key_IdsPersistor() {
        }

        public Api_Key_Ids[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Api_Key_Ids[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Api_Key_Ids::new).toArray(Api_Key_Ids[]::new);
        }

        public void save(Api_Key_Ids[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class BucketWidthEnabledRef
    implements BooleanReference {
        private BucketWidthEnabledRef() {
        }
    }

    private static final class Bucket_WidthChoicesProvider
    implements StringChoicesProvider {
        private Bucket_WidthChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(BUCKET_WIDTH_VALUES);
        }
    }

    private static final class EndTimeEnabledRef
    implements BooleanReference {
        private EndTimeEnabledRef() {
        }
    }

    private static final class GroupByEnabledRef
    implements BooleanReference {
        private GroupByEnabledRef() {
        }
    }

    static final class Group_By
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Group_ByChoicesProvider.class)
        String text;

        Group_By() {
        }

        Group_By(String text) {
            this.text = text;
        }

        private static final class Group_ByChoicesProvider
        implements StringChoicesProvider {
            private Group_ByChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(GROUP_BY_VALUES);
            }
        }
    }

    private static final class Group_ByPersistor
    implements NodeParametersPersistor<Group_By[]> {
        static final String CONFIG_KEY = "groupBy";

        private Group_ByPersistor() {
        }

        public Group_By[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Group_By[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Group_By::new).toArray(Group_By[]::new);
        }

        public void save(Group_By[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class LimitEnabledRef
    implements BooleanReference {
        private LimitEnabledRef() {
        }
    }

    static final class Models
    implements WidgetGroup {
        @Widget(title="", description="")
        String text;

        Models() {
        }

        Models(String text) {
            this.text = text;
        }
    }

    private static final class ModelsEnabledRef
    implements BooleanReference {
        private ModelsEnabledRef() {
        }
    }

    private static final class ModelsPersistor
    implements NodeParametersPersistor<Models[]> {
        static final String CONFIG_KEY = "models";

        private ModelsPersistor() {
        }

        public Models[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Models[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Models::new).toArray(Models[]::new);
        }

        public void save(Models[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class PageEnabledRef
    implements BooleanReference {
        private PageEnabledRef() {
        }
    }

    private static final class ProjectIdsEnabledRef
    implements BooleanReference {
        private ProjectIdsEnabledRef() {
        }
    }

    static final class Project_Ids
    implements WidgetGroup {
        @Widget(title="", description="")
        String text;

        Project_Ids() {
        }

        Project_Ids(String text) {
            this.text = text;
        }
    }

    private static final class Project_IdsPersistor
    implements NodeParametersPersistor<Project_Ids[]> {
        static final String CONFIG_KEY = "projectIds";

        private Project_IdsPersistor() {
        }

        public Project_Ids[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Project_Ids[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Project_Ids::new).toArray(Project_Ids[]::new);
        }

        public void save(Project_Ids[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class UsageModerationsNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private UsageModerationsNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class UserIdsEnabledRef
    implements BooleanReference {
        private UserIdsEnabledRef() {
        }
    }

    static final class User_Ids
    implements WidgetGroup {
        @Widget(title="", description="")
        String text;

        User_Ids() {
        }

        User_Ids(String text) {
            this.text = text;
        }
    }

    private static final class User_IdsPersistor
    implements NodeParametersPersistor<User_Ids[]> {
        static final String CONFIG_KEY = "userIds";

        private User_IdsPersistor() {
        }

        public User_Ids[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (User_Ids[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(User_Ids::new).toArray(User_Ids[]::new);
        }

        public void save(User_Ids[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }
}

