/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.cancelbatch;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class CancelBatchNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Batch Id", description="The ID of the batch to cancel.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String batchId = null;
    @Widget(title="Result Format", description="\t<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n\t<p><b>Structured Table:</b> Returns a parsed table with data split into rows\n\tand columns.</p>\n\t<ul>\n\t\t<li><b>Id:</b> </li>\n\t\t<li><b>Object:</b> The object type, which is always <tt>batch</tt>.</li>\n\t\t<li><b>Endpoint:</b> The OpenAI API endpoint used by the batch.</li>\n\t\t<li><b>Errors:</b> </li>\n\t\t<li><b>Input File Id:</b> The ID of the input file for the batch.</li>\n\t\t<li><b>Completion Window:</b> The time frame within which the batch should be processed.</li>\n\t\t<li><b>Status:</b> The current status of the batch.</li>\n\t\t<li><b>Output File Id:</b> The ID of the file containing the outputs of successfully executed requests.</li>\n\t\t<li><b>Error File Id:</b> The ID of the file containing the outputs of requests with errors.</li>\n\t\t<li><b>Created At:</b> The Unix timestamp (in seconds) for when the batch was created.</li>\n\t\t<li><b>In Progress At:</b> The Unix timestamp (in seconds) for when the batch started processing.</li>\n\t\t<li><b>Expires At:</b> The Unix timestamp (in seconds) for when the batch will expire.</li>\n\t\t<li><b>Finalizing At:</b> The Unix timestamp (in seconds) for when the batch started finalizing.</li>\n\t\t<li><b>Completed At:</b> The Unix timestamp (in seconds) for when the batch was completed.</li>\n\t\t<li><b>Failed At:</b> The Unix timestamp (in seconds) for when the batch failed.</li>\n\t\t<li><b>Expired At:</b> The Unix timestamp (in seconds) for when the batch expired.</li>\n\t\t<li><b>Cancelling At:</b> The Unix timestamp (in seconds) for when the batch started cancelling.</li>\n\t\t<li><b>Cancelled At:</b> The Unix timestamp (in seconds) for when the batch was cancelled.</li>\n\t\t<li><b>Request Counts:</b> The request counts for different statuses within the batch.</li>\n\t\t<li><b>Metadata:</b> <p>Set of 16 key-value pairs that can be attached to an object. This can be\nuseful for storing additional information about the object in a structured\nformat, and querying for objects via API or the dashboard.</p>\n<p>Keys are strings with a maximum length of 64 characters. Values are strings\nwith a maximum length of 512 characters.</p></li>\n\t</ul>\n\t<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n\t<ul>\n\t\t<li><b>body:</b> Response body</li>\n\t\t<li><b>status:</b> HTTP status code</li>\n\t</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=CancelBatchNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"id\":\"rows[0][0]\",\"object\":\"rows[0][1]\",\"endpoint\":\"rows[0][2]\",\"errors\":\"rows[0][3]\",\"input_file_id\":\"rows[0][4]\",\"completion_window\":\"rows[0][5]\",\"status\":\"rows[0][6]\",\"output_file_id\":\"rows[0][7]\",\"error_file_id\":\"rows[0][8]\",\"created_at\":\"rows[0][9]\",\"in_progress_at\":\"rows[0][10]\",\"expires_at\":\"rows[0][11]\",\"finalizing_at\":\"rows[0][12]\",\"completed_at\":\"rows[0][13]\",\"failed_at\":\"rows[0][14]\",\"expired_at\":\"rows[0][15]\",\"cancelling_at\":\"rows[0][16]\",\"cancelled_at\":\"rows[0][17]\",\"request_counts\":\"rows[0][18]\",\"metadata\":\"rows[0][19]\"}}]").addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Object", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Endpoint", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Errors", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Input File Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Completion Window", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Output File Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Error File Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("In Progress At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Expires At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Finalizing At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Completed At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Failed At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Expired At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Cancelling At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Cancelled At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Request Counts", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Metadata", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    CancelBatchNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.batchId == null || this.batchId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cBatch Id\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("batch_id", this.batchId));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class CancelBatchNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private CancelBatchNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

