/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.createconversationitems;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import com.nodepit.nodes.openai.v1.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.text.TextAreaWidget;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class CreateConversationItemsNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Conversation Id", description="The ID of the conversation to add the item to.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String conversationId = null;
    @Widget(title="Set Include", description="Enable to set the optional field <b>Include</b>")
    @ValueReference(value=IncludeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean includeEnabled = false;
    @Widget(title="Include", description="\tAdditional fields to include in the response. See the <tt>include</tt>\nparameter for <a href=\"https://platform.openai.com/docs/api-reference/conversations/list-items#conversations_list_items-include\">listing Conversation items above</a> for more information.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=IncludeEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=IncludePersistor.class)
    Include[] include = new Include[]{new Include(INCLUDE_VALUES[0])};
    private static final String[] INCLUDE_VALUES = new String[]{"code_interpreter_call.outputs", "computer_call_output.output.image_url", "file_search_call.results", "message.input_image.image_url", "message.output_text.logprobs", "reasoning.encrypted_content"};
    @Widget(title="Body", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextAreaWidget(rows=15)
    String body = BODY_DEFAULT_VALUE;
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", CreateConversationItemsNodeParameters.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Object:</b> The type of object returned, must be <tt>list</tt>.</li>\n\t<li><b>Data:</b> A list of conversation items.</li>\n\t<li><b>Has More:</b> Whether there are more items available.</li>\n\t<li><b>First Id:</b> The ID of the first item in the list.</li>\n\t<li><b>Last Id:</b> The ID of the last item in the list.</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=CreateConversationItemsNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"object\":\"rows[0][0]\",\"data\":\"rows[0][1]\",\"has_more\":\"rows[0][2]\",\"first_id\":\"rows[0][3]\",\"last_id\":\"rows[0][4]\"}}]").addBodyColumn(new DataColumnSpecCreator("Object", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Data", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Has More", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("First Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Last Id", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    CreateConversationItemsNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.conversationId == null || this.conversationId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cConversation Id\u201d is required.");
        }
        if (this.body == null || this.body.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cBody\u201d is required.");
        }
        if (!Utils.validateJsonBySchema(this.body, BODY_JSON_SCHEMA_FILE, this.getClass())) {
            throw new InvalidSettingsException("\u201cBody\u201d does not conform to the JSON schema.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("conversation_id", this.conversationId));
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.includeEnabled) {
            Arrays.stream(this.include).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("include", value.text));
            });
        }
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.JSON;
    }

    @Override
    public String getJsonBody() {
        return this.body;
    }

    private static final class CreateConversationItemsNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private CreateConversationItemsNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    static final class Include
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=IncludeChoicesProvider.class)
        String text;

        Include() {
        }

        Include(String text) {
            this.text = text;
        }

        private static final class IncludeChoicesProvider
        implements StringChoicesProvider {
            private IncludeChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(INCLUDE_VALUES);
            }
        }
    }

    private static final class IncludeEnabledRef
    implements BooleanReference {
        private IncludeEnabledRef() {
        }
    }

    private static final class IncludePersistor
    implements NodeParametersPersistor<Include[]> {
        static final String CONFIG_KEY = "include";

        private IncludePersistor() {
        }

        public Include[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Include[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Include::new).toArray(Include[]::new);
        }

        public void save(Include[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }
}

