/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.createrealtimesession;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import com.nodepit.nodes.openai.v1.Utils;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.text.TextAreaWidget;

class CreateRealtimeSessionNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Body", description="Create an ephemeral API key with the given session configuration.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextAreaWidget(rows=15)
    String body = BODY_DEFAULT_VALUE;
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", CreateRealtimeSessionNodeParameters.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    @Widget(title="Result Format", description="\t<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n\t<p><b>Structured Table:</b> Returns a parsed table with data split into rows\n\tand columns.</p>\n\t<ul>\n\t\t<li><b>Client Secret:</b> Ephemeral key returned by the API.</li>\n\t\t<li><b>Modalities:</b> The set of modalities the model can respond with. To disable audio,\nset this to [&quot;text&quot;].</li>\n\t\t<li><b>Instructions:</b> <p>The default system instructions (i.e. system message) prepended to model\ncalls. This field allows the client to guide the model on desired\nresponses. The model can be instructed on response content and format,\n(e.g. &quot;be extremely succinct&quot;, &quot;act friendly&quot;, &quot;here are examples of good\nresponses&quot;) and on audio behavior (e.g. &quot;talk quickly&quot;, &quot;inject emotion\ninto your voice&quot;, &quot;laugh frequently&quot;). The instructions are not guaranteed\nto be followed by the model, but they provide guidance to the model on the\ndesired behavior.</p>\n<p>Note that the server sets default instructions which will be used if this\nfield is not set and are visible in the <tt>session.created</tt> event at the\nstart of the session.</p></li>\n\t\t<li><b>Voice:</b> </li>\n\t\t<li><b>Input Audio Format:</b> The format of input audio. Options are <tt>pcm16</tt>, <tt>g711_ulaw</tt>, or <tt>g711_alaw</tt>.</li>\n\t\t<li><b>Output Audio Format:</b> The format of output audio. Options are <tt>pcm16</tt>, <tt>g711_ulaw</tt>, or <tt>g711_alaw</tt>.</li>\n\t\t<li><b>Input Audio Transcription:</b> Configuration for input audio transcription, defaults to off and can be\nset to <tt>null</tt> to turn off once on. Input audio transcription is not native\nto the model, since the model consumes audio directly. Transcription runs\nasynchronously and should be treated as rough guidance\nrather than the representation understood by the model.</li>\n\t\t<li><b>Speed:</b> The speed of the model's spoken response. 1.0 is the default speed. 0.25 is\nthe minimum speed. 1.5 is the maximum speed. This value can only be changed\nin between model turns, not while a response is in progress.</li>\n\t\t<li><b>Tracing:</b> <p>Configuration options for tracing. Set to null to disable tracing. Once\ntracing is enabled for a session, the configuration cannot be modified.</p>\n<p><tt>auto</tt> will create a trace for the session with default values for the\nworkflow name, group id, and metadata.</p></li>\n\t\t<li><b>Turn Detection:</b> Configuration for turn detection. Can be set to <tt>null</tt> to turn off. Server\nVAD means that the model will detect the start and end of speech based on\naudio volume and respond at the end of user speech.</li>\n\t\t<li><b>Tools:</b> Tools (functions) available to the model.</li>\n\t\t<li><b>Tool Choice:</b> How the model chooses tools. Options are <tt>auto</tt>, <tt>none</tt>, <tt>required</tt>, or\nspecify a function.</li>\n\t\t<li><b>Temperature:</b> Sampling temperature for the model, limited to [0.6, 1.2]. Defaults to 0.8.</li>\n\t\t<li><b>Max Response Output Tokens:</b> Maximum number of output tokens for a single assistant response,\ninclusive of tool calls. Provide an integer between 1 and 4096 to\nlimit output tokens, or <tt>inf</tt> for the maximum available tokens for a\ngiven model. Defaults to <tt>inf</tt>.</li>\n\t</ul>\n\t<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n\t<ul>\n\t\t<li><b>body:</b> Response body</li>\n\t\t<li><b>status:</b> HTTP status code</li>\n\t</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=CreateRealtimeSessionNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"client_secret\":\"rows[0][0]\",\"modalities\":\"rows[0][1]\",\"instructions\":\"rows[0][2]\",\"voice\":\"rows[0][3]\",\"input_audio_format\":\"rows[0][4]\",\"output_audio_format\":\"rows[0][5]\",\"input_audio_transcription\":\"rows[0][6]\",\"speed\":\"rows[0][7]\",\"tracing\":\"rows[0][8]\",\"turn_detection\":\"rows[0][9]\",\"tools\":\"rows[0][10]\",\"tool_choice\":\"rows[0][11]\",\"temperature\":\"rows[0][12]\",\"max_response_output_tokens\":\"rows[0][13]\"}}]").addBodyColumn(new DataColumnSpecCreator("Client Secret", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Modalities", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Instructions", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Voice", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Input Audio Format", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Output Audio Format", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Input Audio Transcription", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Speed", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Tracing", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Turn Detection", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Tools", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Tool Choice", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Temperature", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Max Response Output Tokens", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    CreateRealtimeSessionNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.body == null || this.body.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cBody\u201d is required.");
        }
        if (!Utils.validateJsonBySchema(this.body, BODY_JSON_SCHEMA_FILE, this.getClass())) {
            throw new InvalidSettingsException("\u201cBody\u201d does not conform to the JSON schema.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.JSON;
    }

    @Override
    public String getJsonBody() {
        return this.body;
    }

    private static final class CreateRealtimeSessionNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private CreateRealtimeSessionNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

