/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.createrealtimetranscriptionsession;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import com.nodepit.nodes.openai.v1.Utils;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.text.TextAreaWidget;

class CreateRealtimeTranscriptionSessionNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Body", description="Create an ephemeral API key with the given session configuration.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextAreaWidget(rows=15)
    String body = BODY_DEFAULT_VALUE;
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", CreateRealtimeTranscriptionSessionNodeParameters.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    @Widget(title="Result Format", description="\t<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n\t<p><b>Structured Table:</b> Returns a parsed table with data split into rows\n\tand columns.</p>\n\t<ul>\n\t\t<li><b>Client Secret:</b> Ephemeral key returned by the API. Only present when the session is\ncreated on the server via REST API.</li>\n\t\t<li><b>Modalities:</b> The set of modalities the model can respond with. To disable audio,\nset this to [&quot;text&quot;].</li>\n\t\t<li><b>Input Audio Format:</b> The format of input audio. Options are <tt>pcm16</tt>, <tt>g711_ulaw</tt>, or <tt>g711_alaw</tt>.</li>\n\t\t<li><b>Input Audio Transcription:</b> Configuration of the transcription model.</li>\n\t\t<li><b>Turn Detection:</b> Configuration for turn detection. Can be set to <tt>null</tt> to turn off. Server\nVAD means that the model will detect the start and end of speech based on\naudio volume and respond at the end of user speech.</li>\n\t</ul>\n\t<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n\t<ul>\n\t\t<li><b>body:</b> Response body</li>\n\t\t<li><b>status:</b> HTTP status code</li>\n\t</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=CreateRealtimeTranscriptionSessionNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"client_secret\":\"rows[0][0]\",\"modalities\":\"rows[0][1]\",\"input_audio_format\":\"rows[0][2]\",\"input_audio_transcription\":\"rows[0][3]\",\"turn_detection\":\"rows[0][4]\"}}]").addBodyColumn(new DataColumnSpecCreator("Client Secret", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Modalities", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Input Audio Format", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Input Audio Transcription", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Turn Detection", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    CreateRealtimeTranscriptionSessionNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.body == null || this.body.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cBody\u201d is required.");
        }
        if (!Utils.validateJsonBySchema(this.body, BODY_JSON_SCHEMA_FILE, this.getClass())) {
            throw new InvalidSettingsException("\u201cBody\u201d does not conform to the JSON schema.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.JSON;
    }

    @Override
    public String getJsonBody() {
        return this.body;
    }

    private static final class CreateRealtimeTranscriptionSessionNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private CreateRealtimeTranscriptionSessionNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

