/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.getconversationitem;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetConversationItemNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Conversation Id", description="The ID of the conversation that contains the item.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String conversationId = null;
    @Widget(title="Item Id", description="The ID of the item to retrieve.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String itemId = null;
    @Widget(title="Set Include", description="Enable to set the optional field <b>Include</b>")
    @ValueReference(value=IncludeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean includeEnabled = false;
    @Widget(title="Include", description="\tAdditional fields to include in the response. See the <tt>include</tt>\nparameter for <a href=\"https://platform.openai.com/docs/api-reference/conversations/list-items#conversations_list_items-include\">listing Conversation items above</a> for more information.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=IncludeEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=IncludePersistor.class)
    Include[] include = new Include[]{new Include(INCLUDE_VALUES[0])};
    private static final String[] INCLUDE_VALUES = new String[]{"code_interpreter_call.outputs", "computer_call_output.output.image_url", "file_search_call.results", "message.input_image.image_url", "message.output_text.logprobs", "reasoning.encrypted_content"};
    @Widget(title="Result Format", description="\t<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n\t<p><b>Structured Table:</b> Returns a parsed table with data split into rows\n\tand columns.</p>\n\t<ul>\n\t\t<li><b>Type:</b> The type of the custom tool call output. Always <tt>custom_tool_call_output</tt>.</li>\n\t\t<li><b>Id:</b> The unique ID of the custom tool call output in the OpenAI platform.</li>\n\t\t<li><b>Status:</b> The status of the item. One of <tt>in_progress</tt>, <tt>completed</tt>, or <tt>incomplete</tt>.</li>\n\t\t<li><b>Role:</b> The role of the message. One of <tt>unknown</tt>, <tt>user</tt>, <tt>assistant</tt>, <tt>system</tt>, <tt>critic</tt>, <tt>discriminator</tt>, <tt>developer</tt>, or <tt>tool</tt>.</li>\n\t\t<li><b>Content:</b> Reasoning text content.</li>\n\t\t<li><b>Call Id:</b> The call ID, used to map this custom tool call output to a custom tool call.</li>\n\t\t<li><b>Name:</b> The name of the custom tool being called.</li>\n\t\t<li><b>Arguments:</b> A JSON string of the arguments passed to the tool.</li>\n\t\t<li><b>Output:</b> The output from the custom tool call generated by your code.</li>\n\t\t<li><b>Queries:</b> The queries used to search for files.</li>\n\t\t<li><b>Results:</b> The results of the file search tool call.</li>\n\t\t<li><b>Action:</b> Execute a shell command on the server.</li>\n\t\t<li><b>Result:</b> The generated image encoded in base64.</li>\n\t\t<li><b>Pending Safety Checks:</b> The pending safety checks for the computer call.</li>\n\t\t<li><b>Acknowledged Safety Checks:</b> The safety checks reported by the API that have been acknowledged by the\ndeveloper.</li>\n\t\t<li><b>Encrypted Content:</b> The encrypted content of the reasoning item - populated when a response is\ngenerated with <tt>reasoning.encrypted_content</tt> in the <tt>include</tt> parameter.</li>\n\t\t<li><b>Summary:</b> Reasoning summary content.</li>\n\t\t<li><b>Container Id:</b> The ID of the container used to run the code.</li>\n\t\t<li><b>Code:</b> The code to run, or null if not available.</li>\n\t\t<li><b>Outputs:</b> The outputs generated by the code interpreter, such as logs or images.\nCan be null if no outputs are available.</li>\n\t\t<li><b>Server Label:</b> The label of the MCP server running the tool.</li>\n\t\t<li><b>Tools:</b> The tools available on the server.</li>\n\t\t<li><b>Error:</b> The error from the tool call, if any.</li>\n\t\t<li><b>Approval Request Id:</b> The ID of the approval request being answered.</li>\n\t\t<li><b>Approve:</b> Whether the request was approved.</li>\n\t\t<li><b>Reason:</b> Optional reason for the decision.</li>\n\t\t<li><b>Input:</b> The input for the custom tool call generated by the model.</li>\n\t</ul>\n\t<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n\t<ul>\n\t\t<li><b>body:</b> Response body</li>\n\t\t<li><b>status:</b> HTTP status code</li>\n\t</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetConversationItemNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"type\":\"rows[0][0]\",\"id\":\"rows[0][1]\",\"status\":\"rows[0][2]\",\"role\":\"rows[0][3]\",\"content\":\"rows[0][4]\",\"call_id\":\"rows[0][5]\",\"name\":\"rows[0][6]\",\"arguments\":\"rows[0][7]\",\"output\":\"rows[0][8]\",\"queries\":\"rows[0][9]\",\"results\":\"rows[0][10]\",\"action\":\"rows[0][11]\",\"result\":\"rows[0][12]\",\"pending_safety_checks\":\"rows[0][13]\",\"acknowledged_safety_checks\":\"rows[0][14]\",\"encrypted_content\":\"rows[0][15]\",\"summary\":\"rows[0][16]\",\"container_id\":\"rows[0][17]\",\"code\":\"rows[0][18]\",\"outputs\":\"rows[0][19]\",\"server_label\":\"rows[0][20]\",\"tools\":\"rows[0][21]\",\"error\":\"rows[0][22]\",\"approval_request_id\":\"rows[0][23]\",\"approve\":\"rows[0][24]\",\"reason\":\"rows[0][25]\",\"input\":\"rows[0][26]\"}}]").addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Role", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Content", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Call Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Arguments", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Output", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Queries", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Results", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Action", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Result", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Pending Safety Checks", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Acknowledged Safety Checks", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Encrypted Content", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Summary", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Container Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Code", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Outputs", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Server Label", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Tools", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Error", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Approval Request Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Approve", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Reason", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Input", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetConversationItemNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.conversationId == null || this.conversationId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cConversation Id\u201d is required.");
        }
        if (this.itemId == null || this.itemId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cItem Id\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("conversation_id", this.conversationId));
        params.add(new HttpRequestNodeParameters.Param("item_id", this.itemId));
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.includeEnabled) {
            Arrays.stream(this.include).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("include", value.text));
            });
        }
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class GetConversationItemNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetConversationItemNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    static final class Include
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=IncludeChoicesProvider.class)
        String text;

        Include() {
        }

        Include(String text) {
            this.text = text;
        }

        private static final class IncludeChoicesProvider
        implements StringChoicesProvider {
            private IncludeChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(INCLUDE_VALUES);
            }
        }
    }

    private static final class IncludeEnabledRef
    implements BooleanReference {
        private IncludeEnabledRef() {
        }
    }

    private static final class IncludePersistor
    implements NodeParametersPersistor<Include[]> {
        static final String CONFIG_KEY = "include";

        private IncludePersistor() {
        }

        public Include[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Include[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Include::new).toArray(Include[]::new);
        }

        public void save(Include[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }
}

