/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.modifyassistant;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import com.nodepit.nodes.openai.v1.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.text.TextAreaWidget;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class ModifyAssistantNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="OpenAI Beta", description="Calls to the Assistants API require that you pass a beta HTTP header.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Open_AI_BetaChoicesProvider.class)
    String openAIBeta = OPEN_AI_BETA_VALUES[0];
    private static final String[] OPEN_AI_BETA_VALUES = new String[]{"assistants=v2"};
    @Widget(title="Assistant Id", description="The ID of the assistant to modify.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String assistantId = null;
    @Widget(title="Body", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextAreaWidget(rows=15)
    String body = BODY_DEFAULT_VALUE;
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", ModifyAssistantNodeParameters.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    @Widget(title="Result Format", description="\t<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n\t<p><b>Structured Table:</b> Returns a parsed table with data split into rows\n\tand columns.</p>\n\t<ul>\n\t\t<li><b>Id:</b> The identifier, which can be referenced in API endpoints.</li>\n\t\t<li><b>Object:</b> The object type, which is always <tt>assistant</tt>.</li>\n\t\t<li><b>Created At:</b> The Unix timestamp (in seconds) for when the assistant was created.</li>\n\t\t<li><b>Name:</b> The name of the assistant. The maximum length is 256 characters.</li>\n\t\t<li><b>Description:</b> The description of the assistant. The maximum length is 512 characters.</li>\n\t\t<li><b>Model:</b> ID of the model to use. You can use the <a href=\"https://platform.openai.com/docs/api-reference/models/list\">List models</a> API to see all of your available models, or see our <a href=\"https://platform.openai.com/docs/models\">Model overview</a> for descriptions of them.</li>\n\t\t<li><b>Instructions:</b> The system instructions that the assistant uses. The maximum length is 256,000 characters.</li>\n\t\t<li><b>Tools:</b> A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types <tt>code_interpreter</tt>, <tt>file_search</tt>, or <tt>function</tt>.</li>\n\t\t<li><b>Tool Resources:</b> A set of resources that are used by the assistant's tools. The resources are specific to the type of tool. For example, the <tt>code_interpreter</tt> tool requires a list of file IDs, while the <tt>file_search</tt> tool requires a list of vector store IDs.</li>\n\t\t<li><b>Metadata:</b> <p>Set of 16 key-value pairs that can be attached to an object. This can be\nuseful for storing additional information about the object in a structured\nformat, and querying for objects via API or the dashboard.</p>\n<p>Keys are strings with a maximum length of 64 characters. Values are strings\nwith a maximum length of 512 characters.</p></li>\n\t\t<li><b>Temperature:</b> What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.</li>\n\t\t<li><b>Top P:</b> <p>An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.</p>\n<p>We generally recommend altering this or temperature but not both.</p></li>\n\t\t<li><b>Response Format:</b> <p>Specifies the format that the model must output. Compatible with <a href=\"https://platform.openai.com/docs/models#gpt-4o\">GPT-4o</a>, <a href=\"https://platform.openai.com/docs/models#gpt-4-turbo-and-gpt-4\">GPT-4 Turbo</a>, and all GPT-3.5 Turbo models since <tt>gpt-3.5-turbo-1106</tt>.</p>\n<p>Setting to <tt>{ &quot;type&quot;: &quot;json_schema&quot;, &quot;json_schema&quot;: {...} }</tt> enables Structured Outputs which ensures the model will match your supplied JSON schema. Learn more in the <a href=\"https://platform.openai.com/docs/guides/structured-outputs\">Structured Outputs guide</a>.</p>\n<p>Setting to <tt>{ &quot;type&quot;: &quot;json_object&quot; }</tt> enables JSON mode, which ensures the message the model generates is valid JSON.</p>\n<p><b>Important:</b> when using JSON mode, you <b>must</b> also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly &quot;stuck&quot; request. Also note that the message content may be partially cut off if <tt>finish_reason=&quot;length&quot;</tt>, which indicates the generation exceeded <tt>max_tokens</tt> or the conversation exceeded the max context length.</p></li>\n\t</ul>\n\t<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n\t<ul>\n\t\t<li><b>body:</b> Response body</li>\n\t\t<li><b>status:</b> HTTP status code</li>\n\t</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=ModifyAssistantNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"id\":\"rows[0][0]\",\"object\":\"rows[0][1]\",\"created_at\":\"rows[0][2]\",\"name\":\"rows[0][3]\",\"description\":\"rows[0][4]\",\"model\":\"rows[0][5]\",\"instructions\":\"rows[0][6]\",\"tools\":\"rows[0][7]\",\"tool_resources\":\"rows[0][8]\",\"metadata\":\"rows[0][9]\",\"temperature\":\"rows[0][10]\",\"top_p\":\"rows[0][11]\",\"response_format\":\"rows[0][12]\"}}]").addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Object", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Description", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Model", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Instructions", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Tools", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Tool Resources", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Metadata", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Temperature", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Top P", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Response Format", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    ModifyAssistantNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.openAIBeta == null || this.openAIBeta.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOpenAI Beta\u201d is required.");
        }
        if (this.assistantId == null || this.assistantId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cAssistant Id\u201d is required.");
        }
        if (this.body == null || this.body.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cBody\u201d is required.");
        }
        if (!Utils.validateJsonBySchema(this.body, BODY_JSON_SCHEMA_FILE, this.getClass())) {
            throw new InvalidSettingsException("\u201cBody\u201d does not conform to the JSON schema.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("assistant_id", this.assistantId));
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getHeaderParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("OpenAI-Beta", this.openAIBeta));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.JSON;
    }

    @Override
    public String getJsonBody() {
        return this.body;
    }

    private static final class ModifyAssistantNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private ModifyAssistantNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class Open_AI_BetaChoicesProvider
    implements StringChoicesProvider {
        private Open_AI_BetaChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(OPEN_AI_BETA_VALUES);
        }
    }
}

