/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.port;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.nodepit.nodes.openai.v1.InterceptorFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.ModelContentRO;
import org.knime.core.node.ModelContentWO;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.port.AbstractSimplePortObjectSpec;

public class ConfigPortObjectSpec
extends AbstractSimplePortObjectSpec {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(ConfigPortObjectSpec.class);
    public static final String DEFAULT_SERVER_URL = "https://api.openai.com/v1";
    public static final int DEFAULT_NETWORK_TIMEOUT = 60;
    public static final ConfigPortObjectSpec DEFAULT = new ConfigPortObjectSpec();
    private static final String USER_AGENT = "com.nodepit.nodes.openai/2.3.1";
    private String url;
    private List<InterceptorConfig> interceptors = new ArrayList<InterceptorConfig>();

    public ConfigPortObjectSpec() {
        this(DEFAULT_SERVER_URL);
    }

    private ConfigPortObjectSpec(String url, List<InterceptorConfig> interceptors) {
        this.url = url;
        this.interceptors = interceptors;
    }

    public ConfigPortObjectSpec(String url) {
        this(url, Collections.emptyList());
    }

    public static ConfigPortObjectSpec getOrDefault(ConfigPortObjectSpec specOrNull) {
        return Optional.ofNullable(specOrNull).orElseGet(ConfigPortObjectSpec::new);
    }

    public ConfigPortObjectSpec append(InterceptorConfig config) {
        ArrayList<InterceptorConfig> newInterceptors = new ArrayList<InterceptorConfig>(this.interceptors);
        newInterceptors.add(config);
        return new ConfigPortObjectSpec(this.url, newInterceptors);
    }

    public String getUrl() {
        return this.url;
    }

    public OkHttpClient.Builder addInterceptors(OkHttpClient.Builder builder) {
        builder.connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS);
        for (InterceptorConfig config : this.interceptors) {
            LOGGER.debugWithFormat("Adding interceptor %s", new Object[]{config.identifier});
            config.applyToBuilder(builder);
        }
        builder.addInterceptor(chain -> {
            Request request = chain.request().newBuilder().header("User-Agent", USER_AGENT).build();
            return chain.proceed(request);
        });
        return builder;
    }

    protected void save(ModelContentWO model) {
        model.addString("url", this.url);
        model.addStringArray("interceptors", (String[])this.interceptors.stream().map(InterceptorConfig::toJson).toArray(String[]::new));
    }

    protected void load(ModelContentRO model) throws InvalidSettingsException {
        this.url = model.getString("url");
        this.interceptors = Arrays.stream(model.getStringArray("interceptors")).map(InterceptorConfig::fromJson).collect(Collectors.toList());
    }

    public static class InterceptorConfig {
        private final String identifier;
        private final Object config;

        public static InterceptorConfig fromJson(String json) {
            JsonObject jsonObject = (JsonObject)new Gson().fromJson(json, JsonObject.class);
            String identifier = jsonObject.get("identifier").getAsString();
            InterceptorFactory<?> interceptorFactory = InterceptorFactory.create(identifier);
            return interceptorFactory.parseConfig(jsonObject.get("config"));
        }

        public InterceptorConfig(String identifier, Object config) {
            this.identifier = identifier;
            this.config = config;
        }

        private void applyToBuilder(OkHttpClient.Builder builder) {
            InterceptorFactory<?> factory = InterceptorFactory.create(this.identifier);
            builder.addInterceptor(factory.createInterceptorCast(this.config));
            factory.applyAdditionalConfig(builder);
        }

        public String toJson() {
            return new Gson().toJson((Object)this);
        }
    }

    public static class Serializer
    extends AbstractSimplePortObjectSpec.AbstractSimplePortObjectSpecSerializer<ConfigPortObjectSpec> {
    }
}

