/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.updatesiteupdater;

import com.nodepit.updatesiteupdater.Activator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.knime.core.node.KNIMEConstants;
import org.knime.core.util.IEarlyStartup;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class UpdateSiteUpdater
implements IEarlyStartup {
    private static final List<String> UPDATE_SITE_URLS = Arrays.asList("download.nodepit.com", "download.seleniumnodes.com");

    public void run() {
        String knimeVersion = KNIMEConstants.MAJOR + "." + KNIMEConstants.MINOR;
        UpdateSiteUpdater.updateRepository(this.getRepositoryManager(IMetadataRepositoryManager.class), knimeVersion);
        UpdateSiteUpdater.updateRepository(this.getRepositoryManager(IArtifactRepositoryManager.class), knimeVersion);
    }

    static void updateRepository(IRepositoryManager<?> repoManager, String knimeVersion) {
        ArrayList<URI> repoUris = new ArrayList<URI>();
        repoUris.addAll(Arrays.asList(repoManager.getKnownRepositories(0)));
        repoUris.addAll(Arrays.asList(repoManager.getKnownRepositories(8)));
        for (URI repoUri : repoUris) {
            if (!UpdateSiteUpdater.matches(repoUri)) continue;
            URI updatedRepoUri = UpdateSiteUpdater.rewriteUpdateSiteUrl(repoUri, knimeVersion);
            if (repoUri.equals(updatedRepoUri)) {
                System.out.println("Repository " + String.valueOf(repoUri) + " is up-to-date");
                continue;
            }
            String name = repoManager.getRepositoryProperty(repoUri, "name");
            String nickname = repoManager.getRepositoryProperty(repoUri, "p2.nickname");
            String description = repoManager.getRepositoryProperty(repoUri, "description");
            String system = repoManager.getRepositoryProperty(repoUri, "p2.system");
            boolean enabled = repoManager.isEnabled(repoUri);
            repoManager.addRepository(updatedRepoUri);
            repoManager.setRepositoryProperty(updatedRepoUri, "name", name);
            repoManager.setRepositoryProperty(updatedRepoUri, "p2.nickname", nickname);
            repoManager.setRepositoryProperty(updatedRepoUri, "description", description);
            repoManager.setRepositoryProperty(updatedRepoUri, "p2.system", system);
            repoManager.setEnabled(updatedRepoUri, enabled);
            repoManager.removeRepository(repoUri);
            System.out.println("Changed repository " + String.valueOf(repoUri) + " to " + String.valueOf(updatedRepoUri));
        }
    }

    static boolean matches(URI repoUri) {
        return UPDATE_SITE_URLS.stream().anyMatch(url -> repoUri.toString().contains((CharSequence)url));
    }

    static URI rewriteUpdateSiteUrl(URI repoUri, String knimeVersion) {
        try {
            return new URI(repoUri.toString().replaceAll("/\\d+\\.\\d+$", "/" + knimeVersion));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Invalid URI: " + String.valueOf(repoUri));
        }
    }

    private <M extends IRepositoryManager<?>> M getRepositoryManager(Class<M> managerClass) {
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference agentReference = bundleContext.getServiceReference(IProvisioningAgent.class);
        if (agentReference == null) {
            throw new IllegalStateException();
        }
        IProvisioningAgent agent = (IProvisioningAgent)bundleContext.getService(agentReference);
        if (agent == null) {
            throw new IllegalStateException();
        }
        IRepositoryManager repoMgr = (IRepositoryManager)agent.getService(managerClass.getName());
        if (repoMgr == null) {
            throw new IllegalStateException();
        }
        return (M)repoMgr;
    }
}

