/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.createfile;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;

class CreateFileNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File", description="The File object (not file name) to be uploaded.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String file = "";
    @Widget(title="Purpose", description="The intended purpose of the uploaded file. One of: - <tt>assistants</tt>: Used in the Assistants API - <tt>batch</tt>: Used in the Batch API - <tt>fine-tune</tt>: Used for fine-tuning - <tt>vision</tt>: Images used for vision fine-tuning - <tt>user_data</tt>: Flexible file type for any purpose - <tt>evals</tt>: Used for eval data sets\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=PurposeChoicesProvider.class)
    String purpose = PURPOSE_VALUES[0];
    private static final String[] PURPOSE_VALUES = new String[]{"assistants", "batch", "fine-tune", "vision", "user_data", "evals"};
    @Widget(title="Set Expires After", description="Enable to set the optional field <b>Expires After</b>")
    @ValueReference(value=ExpiresAfterEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean expiresAfterEnabled = false;
    @Widget(title="Expires After", description="The expiration policy for a file. By default, files with <tt>purpose=batch</tt> expire after 30 days and all other files are persisted until they are manually deleted.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ExpiresAfterEnabledRef.class, type=Effect.EffectType.SHOW)
    String expiresAfter = null;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Id:</b> The file identifier, which can be referenced in the API endpoints.</li>\n\t<li><b>Bytes:</b> The size of the file, in bytes.</li>\n\t<li><b>Created At:</b> The Unix timestamp (in seconds) for when the file was created.</li>\n\t<li><b>Expires At:</b> The Unix timestamp (in seconds) for when the file will expire.</li>\n\t<li><b>Filename:</b> The name of the file.</li>\n\t<li><b>Object:</b> The object type, which is always <tt>file</tt>.</li>\n\t<li><b>Purpose:</b> The intended purpose of the file. Supported values are <tt>assistants</tt>, <tt>assistants_output</tt>, <tt>batch</tt>, <tt>batch_output</tt>, <tt>fine-tune</tt>, <tt>fine-tune-results</tt>, <tt>vision</tt>, and <tt>user_data</tt>.</li>\n\t<li><b>Status:</b> Deprecated. The current status of the file, which can be either <tt>uploaded</tt>, <tt>processed</tt>, or <tt>error</tt>.</li>\n\t<li><b>Status Details:</b> Deprecated. For details on why a fine-tuning training file failed validation, see the <tt>error</tt> field on <tt>fine_tuning.job</tt>.</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=CreateFileNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"id\":\"rows[0][0]\",\"bytes\":\"rows[0][1]\",\"created_at\":\"rows[0][2]\",\"expires_at\":\"rows[0][3]\",\"filename\":\"rows[0][4]\",\"object\":\"rows[0][5]\",\"purpose\":\"rows[0][6]\",\"status\":\"rows[0][7]\",\"status_details\":\"rows[0][8]\"}}]").addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Bytes", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Expires At", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Filename", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Object", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Purpose", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status Details", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    CreateFileNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.file == null || this.file.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile\u201d is required.");
        }
        if (this.purpose == null || this.purpose.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cPurpose\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.MULTIPART;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getBodyParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("file", new HttpRequestNodeParameters.File(this.file)));
        params.add(new HttpRequestNodeParameters.Param("purpose", String.valueOf(this.purpose)));
        if (this.expiresAfterEnabled) {
            params.add(new HttpRequestNodeParameters.Param("expires_after", String.valueOf(this.expiresAfter)));
        }
        return params;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class CreateFileNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private CreateFileNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class ExpiresAfterEnabledRef
    implements BooleanReference {
        private ExpiresAfterEnabledRef() {
        }
    }

    private static final class PurposeChoicesProvider
    implements StringChoicesProvider {
        private PurposeChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(PURPOSE_VALUES);
        }
    }
}

