/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.createimagevariation;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;
import org.knime.node.parameters.widget.number.NumberInputWidgetValidation;

class CreateImageVariationNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Image", description="The image to use as the basis for the variation(s). Must be a valid PNG file, less than 4MB, and square.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String image = "";
    @Widget(title="Set Model", description="Enable to set the optional field <b>Model</b>")
    @ValueReference(value=ModelEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean modelEnabled = false;
    @Widget(title="Model", description="The model to use for image generation. Only <tt>dall-e-2</tt> is supported at this time.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ModelEnabledRef.class, type=Effect.EffectType.SHOW)
    String model = null;
    @Widget(title="Set N", description="Enable to set the optional field <b>N</b>")
    @ValueReference(value=NEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean nEnabled = false;
    @Widget(title="N", description="The number of images to generate. Must be between 1 and 10.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=NEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget(minValidation=NMinValidation.class, maxValidation=NMaxValidation.class)
    int n = 1;
    @Widget(title="Set Response Format", description="Enable to set the optional field <b>Response Format</b>")
    @ValueReference(value=ResponseFormatEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean responseFormatEnabled = false;
    @Widget(title="Response Format", description="The format in which the generated images are returned. Must be one of <tt>url</tt> or <tt>b64_json</tt>. URLs are only valid for 60 minutes after the image has been generated.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ResponseFormatEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Response_FormatChoicesProvider.class)
    String responseFormat = "url";
    private static final String[] RESPONSE_FORMAT_VALUES = new String[]{"url", "b64_json"};
    @Widget(title="Set Size", description="Enable to set the optional field <b>Size</b>")
    @ValueReference(value=SizeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean sizeEnabled = false;
    @Widget(title="Size", description="The size of the generated images. Must be one of <tt>256x256</tt>, <tt>512x512</tt>, or <tt>1024x1024</tt>.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=SizeEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=SizeChoicesProvider.class)
    String size = "1024x1024";
    private static final String[] SIZE_VALUES = new String[]{"256x256", "512x512", "1024x1024"};
    @Widget(title="Set User", description="Enable to set the optional field <b>User</b>")
    @ValueReference(value=UserEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean userEnabled = false;
    @Widget(title="User", description="A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. <a href=\"https://platform.openai.com/docs/guides/safety-best-practices#end-user-ids\">Learn more</a>.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=UserEnabledRef.class, type=Effect.EffectType.SHOW)
    String user = null;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Created:</b> The Unix timestamp (in seconds) of when the image was created.</li>\n\t<li><b>Data:</b> The list of generated images.</li>\n\t<li><b>Background:</b> The background parameter used for the image generation. Either <tt>transparent</tt> or <tt>opaque</tt>.</li>\n\t<li><b>Output Format:</b> The output format of the image generation. Either <tt>png</tt>, <tt>webp</tt>, or <tt>jpeg</tt>.</li>\n\t<li><b>Size:</b> The size of the image generated. Either <tt>1024x1024</tt>, <tt>1024x1536</tt>, or <tt>1536x1024</tt>.</li>\n\t<li><b>Quality:</b> The quality of the image generated. Either <tt>low</tt>, <tt>medium</tt>, or <tt>high</tt>.</li>\n\t<li><b>Usage:</b> For <tt>gpt-image-1</tt> only, the token usage information for the image generation.</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=CreateImageVariationNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"created\":\"rows[0][0]\",\"data\":\"rows[0][1]\",\"background\":\"rows[0][2]\",\"output_format\":\"rows[0][3]\",\"size\":\"rows[0][4]\",\"quality\":\"rows[0][5]\",\"usage\":\"rows[0][6]\"}}]").addBodyColumn(new DataColumnSpecCreator("Created", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Data", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Background", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Output Format", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Size", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Quality", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Usage", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    CreateImageVariationNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.image == null || this.image.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cImage\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.MULTIPART;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getBodyParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("image", new HttpRequestNodeParameters.File(this.image)));
        if (this.modelEnabled) {
            params.add(new HttpRequestNodeParameters.Param("model", String.valueOf(this.model)));
        }
        if (this.nEnabled) {
            params.add(new HttpRequestNodeParameters.Param("n", String.valueOf(this.n)));
        }
        if (this.responseFormatEnabled) {
            params.add(new HttpRequestNodeParameters.Param("response_format", String.valueOf(this.responseFormat)));
        }
        if (this.sizeEnabled) {
            params.add(new HttpRequestNodeParameters.Param("size", String.valueOf(this.size)));
        }
        if (this.userEnabled) {
            params.add(new HttpRequestNodeParameters.Param("user", String.valueOf(this.user)));
        }
        return params;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class CreateImageVariationNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private CreateImageVariationNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class ModelEnabledRef
    implements BooleanReference {
        private ModelEnabledRef() {
        }
    }

    private static final class NEnabledRef
    implements BooleanReference {
        private NEnabledRef() {
        }
    }

    private static final class NMaxValidation
    extends NumberInputWidgetValidation.MaxValidation {
        private NMaxValidation() {
        }

        public double getMax() {
            return 10.0;
        }
    }

    private static final class NMinValidation
    extends NumberInputWidgetValidation.MinValidation {
        private NMinValidation() {
        }

        public double getMin() {
            return 1.0;
        }
    }

    private static final class ResponseFormatEnabledRef
    implements BooleanReference {
        private ResponseFormatEnabledRef() {
        }
    }

    private static final class Response_FormatChoicesProvider
    implements StringChoicesProvider {
        private Response_FormatChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(RESPONSE_FORMAT_VALUES);
        }
    }

    private static final class SizeChoicesProvider
    implements StringChoicesProvider {
        private SizeChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(SIZE_VALUES);
        }
    }

    private static final class SizeEnabledRef
    implements BooleanReference {
        private SizeEnabledRef() {
        }
    }

    private static final class UserEnabledRef
    implements BooleanReference {
        private UserEnabledRef() {
        }
    }
}

