/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.openai.v1.operation.createtranscription;

import com.nodepit.nodes.openai.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.openai.v1.NodeParametersUtils;
import com.nodepit.nodes.openai.v1.ResponseMapper;
import com.nodepit.nodes.openai.v1.SimpleResponseMapper;
import com.nodepit.nodes.openai.v1.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class CreateTranscriptionNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File", description="The audio file object (not file name) to transcribe, in one of these formats: flac, mp3, mp4, mpeg, mpga, m4a, ogg, wav, or webm.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String file = "";
    @Widget(title="Model", description="ID of the model to use. The options are <tt>gpt-4o-transcribe</tt>, <tt>gpt-4o-mini-transcribe</tt>, and <tt>whisper-1</tt> (which is powered by our open source Whisper V2 model).\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String model = null;
    @Widget(title="Set Language", description="Enable to set the optional field <b>Language</b>")
    @ValueReference(value=LanguageEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean languageEnabled = false;
    @Widget(title="Language", description="The language of the input audio. Supplying the input language in <a href=\"https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes\">ISO-639-1</a> (e.g. <tt>en</tt>) format will improve accuracy and latency.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=LanguageEnabledRef.class, type=Effect.EffectType.SHOW)
    String language = null;
    @Widget(title="Set Prompt", description="Enable to set the optional field <b>Prompt</b>")
    @ValueReference(value=PromptEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean promptEnabled = false;
    @Widget(title="Prompt", description="An optional text to guide the model's style or continue a previous audio segment. The <a href=\"https://platform.openai.com/docs/guides/speech-to-text#prompting\">prompt</a> should match the audio language.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PromptEnabledRef.class, type=Effect.EffectType.SHOW)
    String prompt = null;
    @Widget(title="Set Response Format", description="Enable to set the optional field <b>Response Format</b>")
    @ValueReference(value=ResponseFormatEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean responseFormatEnabled = false;
    @Widget(title="Response Format", description="The format of the output, in one of these options: <tt>json</tt>, <tt>text</tt>, <tt>srt</tt>, <tt>verbose_json</tt>, or <tt>vtt</tt>. For <tt>gpt-4o-transcribe</tt> and <tt>gpt-4o-mini-transcribe</tt>, the only supported format is <tt>json</tt>.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ResponseFormatEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Response_FormatChoicesProvider.class)
    String responseFormat = "json";
    private static final String[] RESPONSE_FORMAT_VALUES = new String[]{"json", "text", "srt", "verbose_json", "vtt"};
    @Widget(title="Set Temperature", description="Enable to set the optional field <b>Temperature</b>")
    @ValueReference(value=TemperatureEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean temperatureEnabled = false;
    @Widget(title="Temperature", description="The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. If set to 0, the model will use <a href=\"https://en.wikipedia.org/wiki/Log_probability\">log probability</a> to automatically increase the temperature until certain thresholds are hit.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=TemperatureEnabledRef.class, type=Effect.EffectType.SHOW)
    String temperature = null;
    @Widget(title="Set Stream", description="Enable to set the optional field <b>Stream</b>")
    @ValueReference(value=StreamEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean streamEnabled = false;
    @Widget(title="Stream", description="\t<p>If set to true, the model response data will be streamed to the client\nas it is generated using <a href=\"https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format\">server-sent events</a>.\nSee the <a href=\"https://platform.openai.com/docs/guides/speech-to-text?lang=curl#streaming-transcriptions\">Streaming section of the Speech-to-Text guide</a>\nfor more information.</p>\n<p>Note: Streaming is not supported for the <tt>whisper-1</tt> model and will be ignored.</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=StreamEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=StreamPersistor.class)
    String stream = "false";
    @Widget(title="Set Chunking Strategy", description="Enable to set the optional field <b>Chunking Strategy</b>")
    @ValueReference(value=ChunkingStrategyEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean chunkingStrategyEnabled = false;
    @Widget(title="Chunking Strategy", description="Controls how the audio is cut into chunks. When set to <tt>&quot;auto&quot;</tt>, the server first normalizes loudness and then uses voice activity detection (VAD) to choose boundaries. <tt>server_vad</tt> object can be provided to tweak VAD detection parameters manually. If unset, the audio is transcribed as a single block.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ChunkingStrategyEnabledRef.class, type=Effect.EffectType.SHOW)
    String chunkingStrategy = null;
    @Widget(title="Set Timestamp Granularities", description="Enable to set the optional field <b>Timestamp Granularities</b>")
    @ValueReference(value=TimestampGranularitiesEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean timestampGranularitiesEnabled = false;
    @Widget(title="Timestamp Granularities", description="The timestamp granularities to populate for this transcription. <tt>response_format</tt> must be set <tt>verbose_json</tt> to use timestamp granularities. Either or both of these options are supported: <tt>word</tt>, or <tt>segment</tt>. Note: There is no additional latency for segment timestamps, but generating word timestamps incurs additional latency.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=TimestampGranularitiesEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Timestamp_GranularitiesPersistor.class)
    Timestamp_Granularities[] timestampGranularities = new Timestamp_Granularities[]{new Timestamp_Granularities("[&quot;segment&quot;]")};
    private static final String[] TIMESTAMP_GRANULARITIES_VALUES = new String[]{"word", "segment"};
    @Widget(title="Set Include", description="Enable to set the optional field <b>Include</b>")
    @ValueReference(value=IncludeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean includeEnabled = false;
    @Widget(title="Include", description="\tAdditional information to include in the transcription response.\n<tt>logprobs</tt> will return the log probabilities of the tokens in the\nresponse to understand the model's confidence in the transcription.\n<tt>logprobs</tt> only works with response_format set to <tt>json</tt> and only with\nthe models <tt>gpt-4o-transcribe</tt> and <tt>gpt-4o-mini-transcribe</tt>.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=IncludeEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=IncludePersistor.class)
    Include[] include = new Include[]{new Include(INCLUDE_VALUES[0])};
    private static final String[] INCLUDE_VALUES = new String[]{"logprobs"};
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Text:</b> The transcribed text.</li>\n\t<li><b>Logprobs:</b> The log probabilities of the tokens in the transcription. Only returned with the models <tt>gpt-4o-transcribe</tt> and <tt>gpt-4o-mini-transcribe</tt> if <tt>logprobs</tt> is added to the <tt>include</tt> array.</li>\n\t<li><b>Usage:</b> Usage statistics for models billed by audio input duration.</li>\n\t<li><b>Language:</b> The language of the input audio.</li>\n\t<li><b>Duration:</b> The duration of the input audio.</li>\n\t<li><b>Words:</b> Extracted words and their corresponding timestamps.</li>\n\t<li><b>Segments:</b> Segments of the transcribed text and their corresponding details.</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=CreateTranscriptionNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"text\":\"rows[0][0]\",\"logprobs\":\"rows[0][1]\",\"usage\":\"rows[0][2]\",\"language\":\"rows[0][3]\",\"duration\":\"rows[0][4]\",\"words\":\"rows[0][5]\",\"segments\":\"rows[0][6]\"}}]").addBodyColumn(new DataColumnSpecCreator("Text", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Logprobs", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Usage", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Language", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Duration", DoubleCell.DoubleCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Words", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Segments", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    CreateTranscriptionNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.file == null || this.file.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.MULTIPART;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getBodyParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("file", new HttpRequestNodeParameters.File(this.file)));
        params.add(new HttpRequestNodeParameters.Param("model", String.valueOf(this.model)));
        if (this.languageEnabled) {
            params.add(new HttpRequestNodeParameters.Param("language", String.valueOf(this.language)));
        }
        if (this.promptEnabled) {
            params.add(new HttpRequestNodeParameters.Param("prompt", String.valueOf(this.prompt)));
        }
        if (this.responseFormatEnabled) {
            params.add(new HttpRequestNodeParameters.Param("response_format", String.valueOf(this.responseFormat)));
        }
        if (this.temperatureEnabled) {
            params.add(new HttpRequestNodeParameters.Param("temperature", String.valueOf(this.temperature)));
        }
        if (this.streamEnabled) {
            params.add(new HttpRequestNodeParameters.Param("stream", String.valueOf(this.stream)));
        }
        if (this.chunkingStrategyEnabled) {
            params.add(new HttpRequestNodeParameters.Param("chunking_strategy", String.valueOf(this.chunkingStrategy)));
        }
        if (this.timestampGranularitiesEnabled) {
            Arrays.stream(this.timestampGranularities).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("timestamp_granularities", value.text));
            });
        }
        if (this.includeEnabled) {
            Arrays.stream(this.include).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("include", value.text));
            });
        }
        return params;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class ChunkingStrategyEnabledRef
    implements BooleanReference {
        private ChunkingStrategyEnabledRef() {
        }
    }

    private static final class CreateTranscriptionNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private CreateTranscriptionNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    static final class Include
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=IncludeChoicesProvider.class)
        String text;

        Include() {
        }

        Include(String text) {
            this.text = text;
        }

        private static final class IncludeChoicesProvider
        implements StringChoicesProvider {
            private IncludeChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(INCLUDE_VALUES);
            }
        }
    }

    private static final class IncludeEnabledRef
    implements BooleanReference {
        private IncludeEnabledRef() {
        }
    }

    private static final class IncludePersistor
    implements NodeParametersPersistor<Include[]> {
        static final String CONFIG_KEY = "include";

        private IncludePersistor() {
        }

        public Include[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Include[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Include::new).toArray(Include[]::new);
        }

        public void save(Include[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class LanguageEnabledRef
    implements BooleanReference {
        private LanguageEnabledRef() {
        }
    }

    private static final class PromptEnabledRef
    implements BooleanReference {
        private PromptEnabledRef() {
        }
    }

    private static final class ResponseFormatEnabledRef
    implements BooleanReference {
        private ResponseFormatEnabledRef() {
        }
    }

    private static final class Response_FormatChoicesProvider
    implements StringChoicesProvider {
        private Response_FormatChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(RESPONSE_FORMAT_VALUES);
        }
    }

    private static final class StreamEnabledRef
    implements BooleanReference {
        private StreamEnabledRef() {
        }
    }

    private static final class StreamPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "stream";

        private StreamPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class TemperatureEnabledRef
    implements BooleanReference {
        private TemperatureEnabledRef() {
        }
    }

    private static final class TimestampGranularitiesEnabledRef
    implements BooleanReference {
        private TimestampGranularitiesEnabledRef() {
        }
    }

    static final class Timestamp_Granularities
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Timestamp_GranularitiesChoicesProvider.class)
        String text;

        Timestamp_Granularities() {
        }

        Timestamp_Granularities(String text) {
            this.text = text;
        }

        private static final class Timestamp_GranularitiesChoicesProvider
        implements StringChoicesProvider {
            private Timestamp_GranularitiesChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(TIMESTAMP_GRANULARITIES_VALUES);
            }
        }
    }

    private static final class Timestamp_GranularitiesPersistor
    implements NodeParametersPersistor<Timestamp_Granularities[]> {
        static final String CONFIG_KEY = "timestampGranularities";

        private Timestamp_GranularitiesPersistor() {
        }

        public Timestamp_Granularities[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Timestamp_Granularities[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Timestamp_Granularities::new).toArray(Timestamp_Granularities[]::new);
        }

        public void save(Timestamp_Granularities[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }
}

